/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.listener;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.threed.service.ThreeDService;
import org.nuxeo.runtime.api.Framework;

public class ThreeDBatchCleanerListener
implements EventListener {
    public static final String GENERATE_BATCH_DATA = "generateBatchData";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("ThreeD") && !doc.isProxy()) {
            Property origThreeDProperty = doc.getProperty("file:content");
            Blob threedMain = (Blob)origThreeDProperty.getValue();
            if ((origThreeDProperty.isDirty() || doc.getProperty("files:files").isDirty()) && threedMain != null) {
                ThreeDService threeDService = (ThreeDService)Framework.getService(ThreeDService.class);
                threeDService.cleanBatchData(doc);
                docCtx.setProperty(GENERATE_BATCH_DATA, (Serializable)Boolean.valueOf(true));
            }
        }
    }
}

