/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.transmissionFormat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.threed.service.ThreeDService;
import org.nuxeo.ecm.platform.threed.transmissionFormat.TransmissionFormatItem;
import org.nuxeo.runtime.api.Framework;

@Name(value="transmissionFormatActions")
@Scope(value=ScopeType.EVENT)
public class TransmissionFormatActions {
    public List<TransmissionFormatItem> getItems(DocumentModel doc) throws PropertyException {
        if (!doc.hasFacet("ThreeD")) {
            return Collections.emptyList();
        }
        int size = ((List)doc.getProperty("threed:transmissionFormats").getValue(List.class)).size();
        ArrayList<TransmissionFormatItem> items = new ArrayList<TransmissionFormatItem>(size);
        for (int i = 0; i < size; ++i) {
            items.add(new TransmissionFormatItem(doc, "threed:transmissionFormats", i));
        }
        return items;
    }

    public boolean isConvertingFormats(DocumentModel doc) {
        ThreeDService service = (ThreeDService)Framework.getLocalService(ThreeDService.class);
        return !service.getBatchProgress(doc.getRepositoryName(), doc.getId()).isUnknown();
    }
}

