/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.radio;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.nuxeo.ecm.platform.ui.web.component.radio.UIRadio;
import org.richfaces.component.util.InputUtils;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;

public class SingleRadioRenderer
extends RendererBase {
    public static final String RENDERER_TYPE = SingleRadioRenderer.class.getName();

    private String convertToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent _component) throws IOException {
        UIRadio component = (UIRadio)_component;
        String clientId = component.getClientId(context);
        UIComponent targetComponent = this.getUtils().findComponentFor((UIComponent)component, component.getFor());
        SelectItem item = component.getSelectItem(context, targetComponent);
        boolean checked = false;
        if (targetComponent instanceof UIOutput) {
            Object currentValue = ((UIOutput)targetComponent).getValue();
            Object itemValue = item.getValue();
            checked = itemValue == null ? currentValue == null : itemValue.equals(currentValue);
        }
        writer.startElement("input", (UIComponent)component);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)this.getUtils().clientId(context, targetComponent), "name");
        writer.writeAttribute("type", (Object)"radio", "type");
        writer.writeAttribute("value", (Object)InputUtils.getConvertedStringValue((FacesContext)context, (UIComponent)targetComponent, (Object)item.getValue()), "value");
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", "checked");
        }
        if (this.isDisabled(targetComponent) || this.isReadonly(targetComponent)) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        String targetOnchange = this.convertToString(RenderKitUtils.getAttributeAndBehaviorsValue((FacesContext)context, (UIComponent)targetComponent, (ComponentAttribute)((ComponentAttribute)RenderKitUtils.attributes().generic("onchange", "onchange", new String[]{"change", "valueChange"}).first())));
        String onchange = this.convertToString(RenderKitUtils.getAttributeAndBehaviorsValue((FacesContext)context, (UIComponent)component, (ComponentAttribute)((ComponentAttribute)RenderKitUtils.attributes().generic("onchange", "onchange", new String[]{"change", "valueChange"}).first())));
        if (targetOnchange != null && !targetOnchange.trim().isEmpty()) {
            String string = onchange = onchange == null ? targetOnchange : targetOnchange + ";" + onchange;
        }
        if (onchange != null && onchange.trim().length() > 0) {
            writer.writeAttribute("onchange", (Object)onchange, "onchange");
        }
        this.getUtils().encodeAttributesFromArray(context, (UIComponent)component, new String[]{"accept", "accesskey", "align", "alt", "checked", "dir", "disabled", "lang", "maxlength", "onblur", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onselect", "readonly", "size", "src", "style", "tabindex", "title", "usemap", "xml:lang"});
        writer.endElement("input");
        writer.startElement("label", (UIComponent)component);
        writer.writeAttribute("for", (Object)clientId, "for");
        writer.writeText((Object)this.convertToString(item.getLabel()), null);
        writer.endElement("label");
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIRadio.class;
    }

    private boolean isDisabled(UIComponent targetComponent) {
        if (targetComponent instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)targetComponent).isDisabled();
        }
        Object disabled = targetComponent.getAttributes().get("disabled");
        return Boolean.TRUE.equals(disabled);
    }

    private boolean isReadonly(UIComponent targetComponent) {
        if (targetComponent instanceof HtmlSelectOneRadio) {
            return ((HtmlSelectOneRadio)targetComponent).isReadonly();
        }
        Object readonly = targetComponent.getAttributes().get("readonly");
        return Boolean.TRUE.equals(readonly);
    }
}

