/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.webapp.seam.SeamHotReloadHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadService;
import org.nuxeo.runtime.service.TimestampedService;

@Name(value="seamReload")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class NuxeoSeamHotReloader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NuxeoSeamHotReloader.class);
    @In(required=false, create=true)
    private transient Principal currentUser;

    @Factory(value="nxDevModeSet", scope=ScopeType.EVENT)
    public boolean isDevModeSet() {
        return Framework.isDevModeSet();
    }

    @Factory(value="seamHotReloadIsEnabled", scope=ScopeType.APPLICATION)
    public boolean isHotReloadEnabled() {
        return SeamHotReloadHelper.isHotReloadEnabled();
    }

    public boolean getCanTriggerFlush() {
        NuxeoPrincipal pal = null;
        if (this.currentUser instanceof NuxeoPrincipal) {
            pal = (NuxeoPrincipal)this.currentUser;
        }
        return this.isDevModeSet() && pal != null && pal.isAdministrator();
    }

    public String doFlush() {
        if (Framework.isDevModeSet()) {
            FacesContext faces = FacesContext.getCurrentInstance();
            String viewId = faces.getViewRoot().getViewId();
            URLPolicyService service = (URLPolicyService)Framework.getService(URLPolicyService.class);
            String outcome = service.getOutcomeFromViewId(viewId, null);
            ReloadService srv = (ReloadService)Framework.getService(ReloadService.class);
            srv.flush();
            Events.instance().raiseEvent("flush", new Object[0]);
            return outcome;
        }
        return null;
    }

    public boolean shouldResetCache(Long cacheTimestamp) {
        if (cacheTimestamp == null) {
            return true;
        }
        Long serviceTimestamp = this.getCurrentCacheTimestamp();
        if (serviceTimestamp == null) {
            return false;
        }
        return cacheTimestamp.compareTo(serviceTimestamp) < 0;
    }

    public Long getCurrentCacheTimestamp() {
        ReloadService service = (ReloadService)Framework.getService(ReloadService.class);
        return service.lastFlushed();
    }

    public boolean shouldResetCache(TimestampedService service, Long cacheTimestamp) {
        if (cacheTimestamp == null || service == null) {
            return true;
        }
        Long serviceTimestamp = service.getLastModified();
        if (serviceTimestamp == null) {
            return false;
        }
        return cacheTimestamp.compareTo(serviceTimestamp) < 0;
    }

    @Observer(value={"flush"}, create=false)
    @BypassInterceptors
    public void triggerResetOnSeamComponents() {
        String[] events = new String[]{"userAllDocumentTypesSelectionChanged", "locationSelectionChanged", "contentRootSelectionChanged", "domainSelectionChanged", "localConfigurationChanged"};
        Events seamEvents = Events.instance();
        for (String event : events) {
            seamEvents.raiseEvent(event, new Object[0]);
        }
    }

    public String doReload() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        String url = BaseURL.getBaseURL((ServletRequest)request);
        url = url + "restAPI/seamReload";
        try {
            response.resetBuffer();
            response.sendRedirect(url);
            response.flushBuffer();
            request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)Boolean.TRUE);
            facesContext.responseComplete();
        }
        catch (IOException e) {
            log.error((Object)"Error during redirect", (Throwable)e);
        }
        return null;
    }
}

