/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.component.AbstractPanelMenu;
import org.richfaces.component.AbstractPanelMenuItem;
import org.richfaces.component.ComponentIterators;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.html.TogglePanelRenderer;
import org.richfaces.renderkit.util.PanelIcons;

public class PanelMenuItemRenderer
extends DivPanelRenderer {
    public static final String SELECT = "select";
    public static final String BEFORE_SELECT = "beforeselect";
    private static final String CSS_CLASS_PREFIX = "rf-pm-itm";
    private static final String TOP_CSS_CLASS_PREFIX = "rf-pm-top-itm";
    private static final ParentPanelMenuPredicate PARENT_PANEL_MENU_PREDICATE = new ParentPanelMenuPredicate();

    protected void doDecode(FacesContext context, UIComponent component) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        AbstractPanelMenuItem menuItem = (AbstractPanelMenuItem)component;
        String compClientId = component.getClientId(context);
        if (requestMap.get(compClientId) != null) {
            if (menuItem.isDisabled() || menuItem.isParentDisabled()) {
                return;
            }
            AbstractPanelMenu parentPanelMenu = PanelMenuItemRenderer.getParentPanelMenu(menuItem);
            if (parentPanelMenu.isImmediate()) {
                menuItem.setImmediate(true);
            }
            new ActionEvent((UIComponent)menuItem).queue();
            context.getPartialViewContext().getRenderIds().add(component.getClientId(context));
        }
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(writer, context, component);
        AbstractPanelMenuItem menuItem = (AbstractPanelMenuItem)component;
        this.encodeHeaderGroupBegin(writer, context, menuItem, this.getCssClass(menuItem, ""));
    }

    private void encodeHeaderGroupBegin(ResponseWriter writer, FacesContext context, AbstractPanelMenuItem menuItem, String classPrefix) throws IOException {
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)(classPrefix + "-gr"), null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        this.encodeHeaderGroupLeftIcon(writer, context, menuItem, classPrefix);
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)(classPrefix + "-lbl"), null);
        String label = menuItem.getLabel();
        if (label != null) {
            writer.writeText((Object)label, null);
        }
    }

    private void encodeHeaderGroupEnd(ResponseWriter writer, FacesContext context, AbstractPanelMenuItem menuItem, String classPrefix) throws IOException {
        writer.endElement("td");
        this.encodeHeaderGroupRightIcon(writer, context, menuItem, classPrefix);
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    private PanelIcons.State getState(AbstractPanelMenuItem item) {
        return PanelMenuItemRenderer.isParentPanelMenuDisabled(item) || item.isDisabled() ? PanelIcons.State.commonDisabled : PanelIcons.State.common;
    }

    private void encodeHeaderGroupRightIcon(ResponseWriter writer, FacesContext context, AbstractPanelMenuItem menuItem, String classPrefix) throws IOException {
        String icon = PanelMenuItemRenderer.isParentPanelMenuDisabled(menuItem) || menuItem.isDisabled() ? menuItem.getRightDisabledIcon() : menuItem.getRightIcon();
        String cssClasses = this.concatClasses(new Object[]{classPrefix + "-exp-ico", menuItem.getRightIconClass()});
        if (icon == null || icon.trim().length() == 0) {
            icon = PanelIcons.transparent.toString();
        }
        this.encodeTdIcon(writer, context, cssClasses, icon, this.getState(menuItem));
    }

    private void encodeHeaderGroupLeftIcon(ResponseWriter writer, FacesContext context, AbstractPanelMenuItem menuItem, String classPrefix) throws IOException {
        String icon = PanelMenuItemRenderer.isParentPanelMenuDisabled(menuItem) || menuItem.isDisabled() ? menuItem.getLeftDisabledIcon() : menuItem.getLeftIcon();
        String cssClasses = this.concatClasses(new Object[]{classPrefix + "-ico", menuItem.getLeftIconClass()});
        if (icon == null || icon.trim().length() == 0) {
            icon = PanelIcons.transparent.toString();
        }
        this.encodeTdIcon(writer, context, cssClasses, icon, this.getState(menuItem));
    }

    private boolean isIconRendered(String attrIconValue) {
        return attrIconValue != null && attrIconValue.trim().length() > 0 && !PanelIcons.none.toString().equals(attrIconValue);
    }

    public void encodeTdIcon(ResponseWriter writer, FacesContext context, String classPrefix, String attrIconValue, PanelIcons.State state) throws IOException {
        block3: {
            if (!this.isIconRendered(attrIconValue)) {
                return;
            }
            writer.startElement("td", null);
            try {
                PanelIcons icon = PanelIcons.valueOf((String)attrIconValue);
                writer.writeAttribute("class", (Object)this.concatClasses(new Object[]{classPrefix, state.getCssClass(icon)}), null);
            }
            catch (IllegalArgumentException e) {
                writer.writeAttribute("class", (Object)classPrefix, null);
                if (attrIconValue == null || attrIconValue.trim().length() == 0) break block3;
                writer.startElement("img", null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.writeURIAttribute("src", (Object)RenderKitUtils.getResourceURL((String)attrIconValue, (FacesContext)context), null);
                writer.endElement("img");
            }
        }
        writer.endElement("td");
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        AbstractPanelMenuItem menuItem = (AbstractPanelMenuItem)component;
        return this.concatClasses(new Object[]{this.getCssClass(menuItem, ""), PanelMenuItemRenderer.attributeAsString(component, "styleClass"), PanelMenuItemRenderer.isParentPanelMenuDisabled(menuItem) || menuItem.isDisabled() ? this.getCssClass(menuItem, "-dis") : "", menuItem.isActiveItem() ? this.getCssClass(menuItem, "-sel") : "", PanelMenuItemRenderer.isParentPanelMenuDisabled(menuItem) || menuItem.isDisabled() ? PanelMenuItemRenderer.attributeAsString(component, "disabledClass") : ""});
    }

    public String getCssClass(AbstractPanelMenuItem item, String postfix) {
        return (item.isTopItem() ? TOP_CSS_CLASS_PREFIX : CSS_CLASS_PREFIX) + postfix;
    }

    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.PanelMenuItem", new Object[]{component.getClientId(context), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractPanelMenuItem panelMenuItem = (AbstractPanelMenuItem)component;
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ajax", TogglePanelRenderer.getAjaxOptions(context, (UIComponent)panelMenuItem));
        options.put("disabled", PanelMenuItemRenderer.isParentPanelMenuDisabled(panelMenuItem) || panelMenuItem.isDisabled());
        options.put("mode", (Object)panelMenuItem.getMode());
        options.put("name", panelMenuItem.getName());
        options.put("selectable", panelMenuItem.getSelectable());
        options.put("unselectable", panelMenuItem.getUnselectable());
        options.put("stylePrefix", this.getCssClass(panelMenuItem, ""));
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuItem, options, SELECT);
        TogglePanelRenderer.addEventOption(context, (UIComponent)panelMenuItem, options, BEFORE_SELECT);
        return options;
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractPanelMenuItem menuItem = (AbstractPanelMenuItem)component;
        this.encodeHeaderGroupEnd(writer, context, menuItem, this.getCssClass(menuItem, ""));
        super.doEncodeEnd(writer, context, component);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        if (requestMap.get(component.getClientId(context)) != null && context.getPartialViewContext().isPartialRequest()) {
            this.addOnCompleteParam(context, component.getClientId(context));
        }
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractPanelMenuItem.class;
    }

    private static AbstractPanelMenu getParentPanelMenu(AbstractPanelMenuItem menuItem) {
        return (AbstractPanelMenu)ComponentIterators.getParent((UIComponent)menuItem, (Predicate)PARENT_PANEL_MENU_PREDICATE);
    }

    static boolean isParentPanelMenuDisabled(AbstractPanelMenuItem menuItem) {
        AbstractPanelMenu parentPanelMenu = (AbstractPanelMenu)ComponentIterators.getParent((UIComponent)menuItem, (Predicate)PARENT_PANEL_MENU_PREDICATE);
        if (parentPanelMenu != null) {
            return parentPanelMenu.isDisabled();
        }
        return false;
    }

    private static class ParentPanelMenuPredicate
    implements Predicate<UIComponent> {
        private ParentPanelMenuPredicate() {
        }

        public boolean apply(UIComponent comp) {
            return comp instanceof AbstractPanelMenu;
        }
    }
}

