/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.importer;

import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.threed.ThreeDConstants;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class ThreeDImporter
extends AbstractFileImporter {
    public static final String MIMETYPE_ZIP = "application/zip";

    public DocumentModel create(CoreSession session, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws IOException {
        boolean isThreeD = ThreeDConstants.SUPPORTED_EXTENSIONS.contains(FileUtils.getFileExtension((String)content.getFilename()));
        boolean isZipThreeD = MIMETYPE_ZIP.equals(content.getMimeType());
        String title = null;
        if (isZipThreeD) {
            title = this.getModelFilename(content);
            boolean bl = isZipThreeD = title != null;
        }
        if (!isThreeD && !isZipThreeD) {
            return null;
        }
        DocumentModel container = session.getDocument((DocumentRef)new PathRef(path));
        String docType = this.getDocType(container);
        if (docType == null) {
            docType = this.getDefaultDocType();
        }
        if (isThreeD) {
            title = FileManagerUtils.fetchTitle((String)content.getFilename());
        }
        DocumentModel doc = session.createDocumentModel(docType);
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        doc.setPathInfo(path, pss.generatePathSegment(doc));
        this.updateDocument(doc, content);
        doc = session.createDocument(doc);
        session.save();
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getModelFilename(Blob zipContent) throws IOException {
        ZipInputStream zipInputStream = null;
        String threeDFilename = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(zipContent.getStream());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                boolean isSupported = ThreeDConstants.SUPPORTED_EXTENSIONS.contains(FileUtils.getFileExtension((String)zipEntry.getName()));
                if (zipEntry.isDirectory() || !isSupported || zipEntry.getName().startsWith(".")) continue;
                threeDFilename = FileManagerUtils.fetchTitle((String)zipEntry.getName());
                break;
            }
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return threeDFilename;
    }

    public String getDefaultDocType() {
        return "ThreeD";
    }

    public boolean isOverwriteByTitle() {
        return true;
    }
}

