/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.rendition;

import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.threed.ThreeDDocument;
import org.nuxeo.ecm.platform.threed.ThreeDRenderView;

public class RenderViewRenditionProvider
implements RenditionProvider {
    public boolean isAvailable(DocumentModel documentModel, RenditionDefinition renditionDefinition) {
        ThreeDDocument threeDDocument = (ThreeDDocument)documentModel.getAdapter(ThreeDDocument.class);
        return threeDDocument != null && threeDDocument.getRenderView(renditionDefinition.getName()) != null;
    }

    public List<Blob> render(DocumentModel documentModel, RenditionDefinition renditionDefinition) {
        ThreeDDocument threeDDocument = (ThreeDDocument)documentModel.getAdapter(ThreeDDocument.class);
        if (threeDDocument == null) {
            return Collections.emptyList();
        }
        ThreeDRenderView renderView = threeDDocument.getRenderView(renditionDefinition.getName());
        return renderView.getContent() != null ? Collections.singletonList(renderView.getContent()) : Collections.emptyList();
    }
}

