/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.renderView;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

public class RenderViewItem {
    public static final Log log = LogFactory.getLog(RenderViewItem.class);
    protected final DocumentModel doc;
    protected final int position;
    protected final String blobPropertyName;
    protected final String thumbnailPropertyName;
    protected final String titlePropertyName;
    protected String filename;
    protected String thumbFilename;
    protected String title;

    public RenderViewItem(DocumentModel doc, String basePropertyPath, int position) {
        this.doc = doc;
        this.position = position;
        String propertyPath = basePropertyPath + "/" + position;
        this.blobPropertyName = propertyPath + "/content";
        this.thumbnailPropertyName = propertyPath + "/thumbnail";
        this.titlePropertyName = propertyPath + "/title";
        try {
            this.filename = ((Blob)doc.getPropertyValue(this.blobPropertyName)).getFilename();
            this.thumbFilename = ((Blob)doc.getPropertyValue(this.blobPropertyName)).getFilename();
            this.title = (String)((Object)doc.getPropertyValue(this.titlePropertyName));
        }
        catch (PropertyException e) {
            log.warn((Object)e);
        }
    }

    public String getThumbnailUrl() {
        return DocumentModelFunctions.bigFileUrl((DocumentModel)this.doc, (String)this.thumbnailPropertyName, (String)this.thumbFilename);
    }

    public String getUrl() {
        return DocumentModelFunctions.bigFileUrl((DocumentModel)this.doc, (String)this.blobPropertyName, (String)this.filename);
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getAzimuth() {
        return Integer.valueOf(this.thumbFilename.split("-")[3]);
    }

    public Integer getZenith() {
        return Integer.valueOf(this.thumbFilename.split("-")[4]);
    }
}

