/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.jsf;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.jsf.ResourceBundleRenderer;

public class PageResourceRenderer
extends ResourceBundleRenderer {
    public static final String RENDERER_TYPE = "org.nuxeo.ecm.web.resources.jsf.PageResource";
    private static final Log log = LogFactory.getLog(PageResourceRenderer.class);

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        String type = (String)attributes.get("type");
        if (StringUtils.isBlank((CharSequence)type)) {
            log.error((Object)("Cannot encode page with empty type at %s" + component.getClientId()));
            return;
        }
        if (!ResourceType.css.equals(type) && !ResourceType.js.equals(type)) {
            log.error((Object)("Unsupported type '" + type + "' to encode page '" + name + "' at " + component.getClientId()));
            return;
        }
        if (ResourceType.css.equals(type)) {
            this.encodeEnd(context, component, ResourceType.css, "/wro/api/v1/resource/page/" + name + ".css");
        } else if (ResourceType.js.equals(type)) {
            this.encodeEnd(context, component, ResourceType.js, "/wro/api/v1/resource/page/" + name + ".js");
        }
        super.encodeEnd(context, component);
    }
}

