/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.adapter;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.threed.ThreeDDocument;
import org.nuxeo.ecm.platform.threed.TransmissionThreeD;
import org.nuxeo.ecm.platform.threed.service.AutomaticLOD;
import org.nuxeo.ecm.platform.threed.service.ThreeDService;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class ThreeDPreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        ThreeDDocument threeDDocument = (ThreeDDocument)dm.getAdapter(ThreeDDocument.class);
        ThreeDService threeDService = (ThreeDService)Framework.getService(ThreeDService.class);
        if (threeDDocument.getTransmissionThreeDs().isEmpty()) {
            return new ArrayList<Blob>();
        }
        AutomaticLOD previewLOD = (AutomaticLOD)threeDService.getAutomaticLODs().iterator().next();
        return this.buildPreview(threeDDocument.getTransmissionThreeD(previewLOD.getName()), dm);
    }

    protected List<Blob> buildPreview(TransmissionThreeD transmissionThreeD, DocumentModel dm) {
        ArrayList<Blob> blobResults = new ArrayList<Blob>();
        String basePath = VirtualHostHelper.getContextPathProperty();
        StringBuffer html = new StringBuffer();
        html.append("<html><head>");
        html.append("<title>" + this.getPreviewTitle(dm) + "</title>");
        html.append(String.format("<script src=\"%s/platform-3d/bower_components/webcomponentsjs/webcomponents-lite.min.js\"></script>", basePath));
        html.append(String.format("<link rel=\"import\" href=\"%s/platform-3d/nuxeo-3d-viewer.html\">", basePath));
        html.append(String.format("<nuxeo-3d-viewer src=\"%s\" loader=\"complete\">", transmissionThreeD.getBlob().getFilename()));
        blobResults.add(transmissionThreeD.getBlob());
        html.append("</nuxeo-3d-viewer>");
        html.append("</body>");
        Blob mainBlob = Blobs.createBlob((String)html.toString(), (String)"text/html", null, (String)"index.html");
        blobResults.add(0, mainBlob);
        return blobResults;
    }
}

