/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.richfaces.application.push.MessageDataSerializer;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.SessionPreSubscriptionEvent;
import org.richfaces.application.push.SubscriptionFailureException;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicEvent;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicListener;
import org.richfaces.application.push.impl.DefaultMessageDataSerializer;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public abstract class AbstractTopic
implements Topic {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private TopicKey key;
    private volatile MessageDataSerializer serializer;
    private volatile boolean allowSubtopics;
    private List<TopicListener> listeners = new CopyOnWriteArrayList<TopicListener>();

    public AbstractTopic(TopicKey key) {
        this.key = key;
    }

    @Override
    public MessageDataSerializer getMessageDataSerializer() {
        if (this.serializer == null) {
            return DefaultMessageDataSerializer.instance();
        }
        return this.serializer;
    }

    @Override
    public void setMessageDataSerializer(MessageDataSerializer serializer) {
        this.serializer = serializer;
    }

    public boolean isAllowSubtopics() {
        return this.allowSubtopics;
    }

    public void setAllowSubtopics(boolean allowSubtopics) {
        this.allowSubtopics = allowSubtopics;
    }

    @Override
    public TopicKey getKey() {
        return this.key;
    }

    @Override
    public void addTopicListener(TopicListener topicListener) {
        TopicListener listener = topicListener;
        this.listeners.add(listener);
    }

    @Override
    public void removeTopicListener(TopicListener topicListener) {
        this.listeners.remove(topicListener);
    }

    @Override
    public void checkSubscription(Session session) throws SubscriptionFailureException {
        SessionPreSubscriptionEvent event = new SessionPreSubscriptionEvent(this, this.getKey(), session);
        for (TopicListener listener : this.listeners) {
            if (!event.isAppropriateListener(listener)) continue;
            try {
                event.invokeListener(listener);
            }
            catch (SubscriptionFailureException e) {
                throw e;
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    private void logError(Exception e) {
        LOGGER.error(MessageFormat.format("Exception invoking listener: {0}", e.getMessage()), e);
    }

    @Override
    public void publishEvent(TopicEvent event) {
        for (TopicListener listener : this.listeners) {
            if (!event.isAppropriateListener(listener)) continue;
            try {
                event.invokeListener(listener);
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    @Override
    public abstract void publish(Object var1) throws MessageException;

    @Override
    public abstract void publish(Object var1, String var2) throws MessageException;
}

