/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.transmissionFormat;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.threed.ThreeDInfo;
import org.nuxeo.ecm.platform.threed.renderView.RenderViewItem;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

public class TransmissionFormatItem {
    public static final Log log = LogFactory.getLog(RenderViewItem.class);
    protected final DocumentModel doc;
    protected final int position;
    protected final String blobPropertyName;
    protected String filename;
    protected Long percPoly;
    protected Long maxPoly;
    protected Long percTex;
    protected String maxTex;
    protected Long size;
    protected ThreeDInfo info;
    protected String name;

    public TransmissionFormatItem(DocumentModel doc, String basePropertyPath, int position) {
        this.doc = doc;
        this.position = position;
        String propertyPath = basePropertyPath + "/" + position;
        this.blobPropertyName = propertyPath + "/content";
        try {
            Blob blob = (Blob)doc.getPropertyValue(this.blobPropertyName);
            this.filename = blob.getFilename();
            this.percPoly = (Long)doc.getPropertyValue(propertyPath + "/percPoly");
            this.maxPoly = (Long)doc.getPropertyValue(propertyPath + "/maxPoly");
            this.percTex = (Long)doc.getPropertyValue(propertyPath + "/percTex");
            this.maxTex = (String)((Object)doc.getPropertyValue(propertyPath + "/maxTex"));
            this.name = (String)((Object)doc.getPropertyValue(propertyPath + "/name"));
            this.info = new ThreeDInfo((Map)((Object)doc.getPropertyValue(propertyPath + "/info")));
            this.size = blob.getLength();
        }
        catch (PropertyException e) {
            log.warn((Object)e);
        }
    }

    private String formatAsReadable(long value, long base, String unit) {
        if (value < base) {
            return value + " " + unit;
        }
        int exp = (int)(Math.log(value) / Math.log(base));
        String pre = String.valueOf("kMGTPE".charAt(exp - 1));
        return String.format("%.1f %s%s", (double)value / Math.pow(base, exp), pre, unit);
    }

    public String getSrc() {
        return DocumentModelFunctions.bigFileUrl((DocumentModel)this.doc, (String)this.blobPropertyName, (String)this.filename);
    }

    public String getPercPoly() {
        return this.percPoly == null ? null : this.percPoly.toString();
    }

    public String getMaxPoly() {
        if (this.maxPoly == null) {
            return null;
        }
        return this.formatAsReadable(this.maxPoly, 1000L, "");
    }

    public String getPercTex() {
        return this.percTex == null ? null : this.percTex.toString();
    }

    public String getMaxTex() {
        return this.maxTex == null ? null : this.maxTex;
    }

    public String getSize() {
        return this.size.toString();
    }

    public ThreeDInfo getInfo() {
        return this.info;
    }

    public String getPolygons() {
        Long polygons = this.info.getPolygons();
        if (polygons == null) {
            return "-";
        }
        return this.formatAsReadable(polygons, 1000L, "");
    }

    public String getTextureSize() {
        Long texturesSize = this.info.getTexturesSize();
        if (texturesSize == null) {
            return "-";
        }
        return this.formatAsReadable(texturesSize, 1024L, "B");
    }

    public Boolean getHasTextures() {
        return this.info.getTexturesSize() > 0L;
    }

    public Boolean getGeometryLodSuccess() {
        return this.info.getGeometryLodSuccess();
    }

    public Boolean getTextureLodSuccess() {
        return this.info.getTextureLodSuccess();
    }

    public String getName() {
        return this.name;
    }
}

