/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.commons.fileupload.FileUploadException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.SimpleFileManager;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.util.FileUploadHelper;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;

@Name(value="pluginUploadRestlet")
@Scope(value=ScopeType.EVENT)
public class PluginUploadRestlet
extends BaseNuxeoRestlet
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected CoreSession documentManager;
    @In(create=true)
    protected transient SimpleFileManager FileManageActions;

    public void handle(Request req, Response res) {
        DocumentModel currentDocument;
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String returnCode = "TRANSF_ERROR";
        String relativePath = "";
        List segments = req.getResourceRef().getSegments();
        List pathElements = segments.subList(5, segments.size());
        for (String pathElement : pathElements) {
            if (pathElement == null || pathElement.trim().equals("")) continue;
            try {
                relativePath = relativePath + '/' + URLDecoder.decode(pathElement, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            if (this.navigationContext.getCurrentServerLocation() == null) {
                this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            }
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            currentDocument = this.navigationContext.getCurrentDocument();
            if (currentDocument == null || !currentDocument.getRef().toString().equals(docid)) {
                currentDocument = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
                this.navigationContext.setCurrentDocument(currentDocument);
            }
        }
        catch (NuxeoException e) {
            PluginUploadRestlet.handleError(res, (Exception)((Object)e));
            return;
        }
        if (currentDocument != null) {
            List<Blob> blobs;
            try {
                blobs = FileUploadHelper.parseRequest(req);
            }
            catch (IOException | FileUploadException e) {
                PluginUploadRestlet.handleError(res, (Exception)e);
                return;
            }
            Blob blob = blobs.get(0);
            try {
                returnCode = this.FileManageActions.addBinaryFileFromPlugin(blob, blob.getFilename(), relativePath);
            }
            catch (NuxeoException e) {
                PluginUploadRestlet.handleError(res, (Exception)((Object)e));
                return;
            }
        }
        res.setEntity(returnCode, MediaType.TEXT_PLAIN);
    }
}

