/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.CategorySubject;
import yarfraw.core.datamodel.Content;
import yarfraw.core.datamodel.Enclosure;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.Id;
import yarfraw.core.datamodel.Link;
import yarfraw.core.datamodel.Person;
import yarfraw.core.datamodel.Source;
import yarfraw.core.datamodel.Text;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemEntry
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private static final Log LOG = LogFactory.getLog(ItemEntry.class);
    private Text _title;
    private List<Link> _links;
    private Text _descriptionOrSummary;
    private List<Person> _authorOrCreator;
    private List<Person> _contributors;
    private Set<CategorySubject> _categorySubjects;
    private String _comments;
    private Enclosure _enclosure;
    private Id _uid;
    private String _pubDate;
    private String _updatedDate;
    private Source _source;
    private Text _rights;
    private Content _content;

    public Text getTitle() {
        return this._title;
    }

    public ItemEntry setTitle(Text title) {
        this._title = title;
        return this;
    }

    public ItemEntry setTitle(String title) {
        return this.setTitle(new Text(title));
    }

    public String getTitleText() {
        return this._title == null ? null : this._title.getText();
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public ItemEntry setLinks(List<Link> links) {
        this._links = links;
        return this;
    }

    public ItemEntry addLink(String ... href) {
        if (ArrayUtils.isEmpty((Object[])href)) {
            LOG.warn((Object)"Empty href array is ignored");
            return this;
        }
        if (this._links == null) {
            this._links = new ArrayList<Link>();
        }
        for (String s : href) {
            this._links.add(new Link(s));
        }
        return this;
    }

    public ItemEntry addLink(Link ... link) {
        if (ArrayUtils.isEmpty((Object[])link)) {
            LOG.warn((Object)"Empty link array is ignored");
            return this;
        }
        if (this._links == null) {
            this._links = new ArrayList<Link>();
        }
        for (Link l : link) {
            this._links.add(l);
        }
        return this;
    }

    public Text getDescriptionOrSummary() {
        return this._descriptionOrSummary;
    }

    public ItemEntry setDescriptionOrSummary(Text descriptionOrSummary) {
        this._descriptionOrSummary = descriptionOrSummary;
        return this;
    }

    public ItemEntry setDescriptionOrSummary(String descriptionOrSummary) {
        if (descriptionOrSummary == null) {
            this._descriptionOrSummary = null;
            return this;
        }
        return this.setDescriptionOrSummary(new Text(descriptionOrSummary));
    }

    public String getDescriptionOrSummaryText() {
        return this._descriptionOrSummary == null ? null : this._descriptionOrSummary.getText();
    }

    public List<Person> getAuthorOrCreator() {
        return this._authorOrCreator;
    }

    public ItemEntry setAuthorOrCreator(List<Person> authorOrCreator) {
        this._authorOrCreator = authorOrCreator;
        return this;
    }

    public ItemEntry addAuthorOrCreator(String ... email) {
        if (ArrayUtils.isEmpty((Object[])email)) {
            LOG.warn((Object)"Empty email array is ignored");
            return this;
        }
        if (this._authorOrCreator == null) {
            this._authorOrCreator = new ArrayList<Person>();
        }
        for (String e : email) {
            this._authorOrCreator.add(new Person(e));
        }
        return this;
    }

    public ItemEntry addAuthorOrCreator(Person ... authorOrCreator) {
        if (ArrayUtils.isEmpty((Object[])authorOrCreator)) {
            LOG.warn((Object)"Empty author array is ignored");
            return this;
        }
        if (this._authorOrCreator == null) {
            this._authorOrCreator = new ArrayList<Person>();
        }
        for (Person p : authorOrCreator) {
            this._authorOrCreator.add(p);
        }
        return this;
    }

    public List<Person> getContributors() {
        return this._contributors;
    }

    public ItemEntry setContributors(List<Person> contributors) {
        this._contributors = contributors;
        return this;
    }

    public ItemEntry addContributor(Person ... contributor) {
        if (ArrayUtils.isEmpty((Object[])contributor)) {
            LOG.warn((Object)"Empty contributor array is ignored");
            return this;
        }
        if (this._contributors == null) {
            this._contributors = new ArrayList<Person>();
        }
        for (Person p : contributor) {
            this._contributors.add(p);
        }
        return this;
    }

    public ItemEntry addContributor(String ... contributor) {
        if (ArrayUtils.isEmpty((Object[])contributor)) {
            LOG.warn((Object)"Empty contributor array is ignored");
            return this;
        }
        if (this._contributors == null) {
            this._contributors = new ArrayList<Person>();
        }
        for (String c : contributor) {
            this._contributors.add(new Person(c));
        }
        return this;
    }

    public Set<CategorySubject> getCategorySubjects() {
        return this._categorySubjects;
    }

    public ItemEntry setCategorySubjects(Set<CategorySubject> categorySubjects) {
        this._categorySubjects = categorySubjects;
        return this;
    }

    public ItemEntry addCategorySubject(String ... categorySubjectOrTerm) {
        if (ArrayUtils.isEmpty((Object[])categorySubjectOrTerm)) {
            LOG.warn((Object)"Empty category array is ignored");
            return this;
        }
        if (this._categorySubjects == null) {
            this._categorySubjects = new HashSet<CategorySubject>();
        }
        for (String c : categorySubjectOrTerm) {
            this._categorySubjects.add(new CategorySubject(c));
        }
        return this;
    }

    public ItemEntry addCategorySubject(CategorySubject ... categorySubject) {
        if (ArrayUtils.isEmpty((Object[])categorySubject)) {
            LOG.warn((Object)"Empty category array is ignored");
            return this;
        }
        if (this._categorySubjects == null) {
            this._categorySubjects = new HashSet<CategorySubject>();
        }
        for (CategorySubject s : categorySubject) {
            this._categorySubjects.add(s);
        }
        return this;
    }

    public String getComments() {
        return this._comments;
    }

    public ItemEntry setComments(String comments) {
        this._comments = comments;
        return this;
    }

    public Enclosure getEnclosure() {
        return this._enclosure;
    }

    public ItemEntry setEnclosure(Enclosure enclosure) {
        this._enclosure = enclosure;
        return this;
    }

    public Id getUid() {
        return this._uid;
    }

    public ItemEntry setUid(Id uid) {
        this._uid = uid;
        return this;
    }

    public ItemEntry setUid(String uid) {
        if (uid == null) {
            this._uid = null;
            return this;
        }
        return this.setUid(new Id(uid));
    }

    public String getPubDate() {
        return this._pubDate;
    }

    public ItemEntry setPubDate(String pubDate) {
        this._pubDate = pubDate;
        return this;
    }

    public ItemEntry setPubDate(Date pubDate, SimpleDateFormat format) {
        return this.setPubDate(format.format(pubDate));
    }

    public String getUpdatedDate() {
        return this._updatedDate;
    }

    public ItemEntry setUpdatedDate(String updatedDate) {
        this._updatedDate = updatedDate;
        return this;
    }

    public ItemEntry setUpdatedDate(Date date, SimpleDateFormat format) {
        return this.setUpdatedDate(format.format(date));
    }

    public Source getSource() {
        return this._source;
    }

    public ItemEntry setSource(Source source) {
        this._source = source;
        return this;
    }

    public Text getRights() {
        return this._rights;
    }

    public String getRightsText() {
        return this._rights == null ? null : this._rights.getText();
    }

    public ItemEntry setRights(Text rights) {
        this._rights = rights;
        return this;
    }

    public ItemEntry setRights(String rights) {
        if (rights == null) {
            this._rights = null;
            return this;
        }
        return this.setRights(new Text(rights));
    }

    public Content getContent() {
        return this._content;
    }

    public ItemEntry setContent(Content content) {
        this._content = content;
        return this;
    }

    public ItemEntry setContent(String contentText) {
        if (this._content == null) {
            this._content = null;
            return this;
        }
        this.setContent(new Content(contentText));
        return this;
    }

    public ItemEntry setOtherAttributes(Map<QName, String> otherAttributes) {
        this._otherAttributes = otherAttributes;
        return this;
    }

    public ItemEntry addOtherAttributes(QName namespace, String attribute) {
        if (this._otherAttributes == null) {
            this._otherAttributes = new HashMap();
        }
        this._otherAttributes.put(namespace, attribute);
        return this;
    }

    public ItemEntry setOtherElements(List<Element> otherElements) {
        this._otherElements = otherElements;
        return this;
    }

    public ItemEntry addOtherElement(Element element) {
        if (this._otherElements == null) {
            this._otherElements = new ArrayList();
        }
        this._otherElements.add(element);
        return this;
    }

    public ItemEntry addOtherElement(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        return this.addOtherElement(XMLUtils.parseXml(xmlString, false, false).getDocumentElement());
    }

    public ItemEntry setBase(String base) {
        this._base = base;
        return this;
    }

    public ItemEntry setLang(String lang) {
        this._lang = lang;
        return this;
    }

    public ItemEntry setLang(Locale lang) {
        this._lang = lang.getLanguage();
        return this;
    }

    public ItemEntry setResource(String resource) {
        this._resource = resource;
        return this;
    }

    public ItemEntry setAbout(String about) {
        this._about = about;
        return this;
    }

    @Override
    public void validate(FeedFormat format) throws ValidationException {
        if (this._title == null && this._descriptionOrSummary == null) {
            throw new ValidationException("Item: At least one of title or description must be present.");
        }
        if (this._categorySubjects != null) {
            for (CategorySubject c : this._categorySubjects) {
                c.validate(format);
            }
        }
        if (this._enclosure != null) {
            this._enclosure.validate(format);
        }
        if (this._uid != null) {
            this._uid.validate(format);
        }
        if (this._source != null) {
            this._source.validate(format);
        }
        if (this._links != null) {
            for (Link link : this._links) {
                if (link == null) continue;
                link.validate(format);
            }
        }
    }
}

