/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;
import yarfraw.utils.XMLUtils;

public class Text
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private TextType _type = TextType.text;
    private Element _xhtmlDiv;
    private String _text;

    public Text() {
    }

    public Text(String text) {
        this._type = TextType.text;
        this.setText(text);
    }

    public String getText() {
        return this._text;
    }

    public Text setText(String text) {
        this._text = text;
        return this;
    }

    public Element getXhtmlDiv() {
        return this._xhtmlDiv;
    }

    public Text setXhtmlDiv(Element xhtmlDiv) {
        this._xhtmlDiv = xhtmlDiv;
        this._type = TextType.xhtml;
        return this;
    }

    public Text setXhtmlDiv(String xhtmlDiv) throws SAXException, IOException, ParserConfigurationException {
        return this.setXhtmlDiv(XMLUtils.parseXml(xhtmlDiv, false, false).getDocumentElement());
    }

    public Text(TextType textType) {
        this.setType(textType);
    }

    public TextType getType() {
        return this._type;
    }

    public Text setType(TextType type) {
        this._type = type;
        return this;
    }

    public Text setBase(String base) {
        this._base = base;
        return this;
    }

    public Text setLang(String lang) {
        this._lang = lang;
        return this;
    }

    public Text setLang(Locale lang) {
        this._lang = lang.getLanguage();
        return this;
    }

    public void validate(FeedFormat format) throws ValidationException {
        ValidationUtils.validateNotNull("Text value should not be null", this._text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextType {
        text,
        html,
        xhtml;

    }
}

