/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.mapping.backward.impl;

import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.generated.atom03.elements.EntryType;
import yarfraw.generated.atom03.elements.FeedType;
import yarfraw.generated.atom03.elements.LinkType;
import yarfraw.generated.atom03.elements.PersonType;
import yarfraw.mapping.backward.ToChannelAtom03;
import yarfraw.mapping.backward.impl.Atom03MappingUtils;

public class ToChannelAtom03Impl
implements ToChannelAtom03 {
    private static final ToChannelAtom03 _instance = new ToChannelAtom03Impl();

    private ToChannelAtom03Impl() {
    }

    public static ToChannelAtom03 getInstance() {
        return _instance;
    }

    public ChannelFeed execute(FeedType feed) {
        if (feed == null) {
            return null;
        }
        ChannelFeed c = new ChannelFeed();
        if (feed.getAuthor() != null) {
            c.addManagingEditorOrAuthorOrPublisher(Atom03MappingUtils.toPerson(feed.getAuthor()));
        }
        if (feed.getContributor() != null) {
            for (PersonType p : feed.getContributor()) {
                c.addContributor(Atom03MappingUtils.toPerson(p));
            }
        }
        c.setRights(feed.getCopyright());
        if (feed.getEntry() != null) {
            for (EntryType e : feed.getEntry()) {
                c.addItem(Atom03MappingUtils.toItemEntry(e));
            }
        }
        c.setGenerator(Atom03MappingUtils.toGenerator(feed.getGenerator()));
        if (feed.getId() != null) {
            c.setUid(feed.getId());
        }
        c.setLang(feed.getLang());
        if (feed.getLink() != null) {
            for (LinkType l : feed.getLink()) {
                c.addLink(Atom03MappingUtils.toLink(l));
            }
        }
        c.setLastBuildOrUpdatedDate(feed.getModified());
        if (feed.getOtherAttributes() != null) {
            c.getOtherAttributes().putAll(feed.getOtherAttributes());
        }
        c.getOtherElements().addAll(Atom03MappingUtils.getElements(feed.getAny()));
        return c;
    }
}

