/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.facelets.vendor;

import com.sun.faces.util.ConcurrentCache;
import com.sun.faces.util.ExpiringConcurrentCache;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewResource;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Facelet;
import javax.faces.view.facelets.FaceletCache;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.platform.ui.web.application.NuxeoUnknownResource;

final class DefaultFaceletCache
extends FaceletCache<Facelet> {
    private static final Logger LOGGER = FacesLogger.FACELETS_FACTORY.getLogger();
    private final ConcurrentCache<URL, Record> _faceletCache;
    private final ConcurrentCache<URL, Record> _metadataFaceletCache;

    DefaultFaceletCache(final long refreshPeriod) {
        final boolean checkExpiry = refreshPeriod > 0L;
        ConcurrentCache.Factory<URL, Record> faceletFactory = new ConcurrentCache.Factory<URL, Record>(){

            public Record newInstance(URL key) throws IOException {
                long lastModified = checkExpiry ? Util.getLastModified((URL)key) : 0L;
                return new Record(System.currentTimeMillis(), lastModified, (Facelet)DefaultFaceletCache.this.getMemberFactory().newInstance(key), refreshPeriod);
            }
        };
        ConcurrentCache.Factory<URL, Record> metadataFaceletFactory = new ConcurrentCache.Factory<URL, Record>(){

            public Record newInstance(URL key) throws IOException {
                long lastModified = checkExpiry ? Util.getLastModified((URL)key) : 0L;
                return new Record(System.currentTimeMillis(), lastModified, (Facelet)DefaultFaceletCache.this.getMetadataMemberFactory().newInstance(key), refreshPeriod);
            }
        };
        if (refreshPeriod == 0L) {
            this._faceletCache = new NoCache(faceletFactory);
            this._metadataFaceletCache = new NoCache(metadataFaceletFactory);
        } else {
            Object checker = refreshPeriod > 0L ? new ExpiryChecker() : new NeverExpired();
            this._faceletCache = new ExpiringConcurrentCache((ConcurrentCache.Factory)faceletFactory, (ExpiringConcurrentCache.ExpiryChecker)checker);
            this._metadataFaceletCache = new ExpiringConcurrentCache((ConcurrentCache.Factory)metadataFaceletFactory, (ExpiringConcurrentCache.ExpiryChecker)checker);
        }
    }

    public Facelet getFacelet(URL url) throws IOException {
        Util.notNull((String)"url", (Object)url);
        Facelet f = null;
        try {
            String path = url.getPath();
            f = path.contains(NuxeoUnknownResource.MARKER) ? this.getErrorFacelet(url, null) : ((Record)this._faceletCache.get((Object)url)).getFacelet();
            if (f == null) {
                f = this.getErrorFacelet(url, null);
            }
        }
        catch (ExecutionException e) {
            f = this.getErrorFacelet(url, e);
        }
        return f;
    }

    protected Facelet getErrorFacelet(URL url, ExecutionException origError) throws IOException {
        boolean errorShouldBeCaught;
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            if (origError != null) {
                this._unwrapIOException(origError);
            }
            return null;
        }
        boolean bl = errorShouldBeCaught = origError != null;
        if (errorShouldBeCaught) {
            Throwable t;
            String errorMessage = origError.getMessage();
            if (errorMessage != null && errorMessage.contains("Error Checking Last Modified for ")) {
                errorShouldBeCaught = false;
            }
            if ((t = origError.getCause()) instanceof FileNotFoundException) {
                errorShouldBeCaught = false;
            }
        }
        if (errorShouldBeCaught) {
            this._unwrapIOException(origError);
            return null;
        }
        try {
            String path = url.getPath();
            String lookupPath = path.startsWith(NuxeoUnknownResource.MARKER) ? path : NuxeoUnknownResource.MARKER + path;
            ViewResource res = ctx.getApplication().getResourceHandler().createViewResource(ctx, lookupPath);
            if (res != null) {
                return ((Record)this._faceletCache.get((Object)res.getURL())).getFacelet();
            }
            return null;
        }
        catch (ExecutionException e) {
            this._unwrapIOException(e);
            return null;
        }
    }

    public boolean isFaceletCached(URL url) {
        Util.notNull((String)"url", (Object)url);
        return this._faceletCache.containsKey((Object)url);
    }

    public Facelet getViewMetadataFacelet(URL url) throws IOException {
        Util.notNull((String)"url", (Object)url);
        Facelet f = null;
        try {
            f = ((Record)this._metadataFaceletCache.get((Object)url)).getFacelet();
        }
        catch (ExecutionException e) {
            this._unwrapIOException(e);
        }
        return f;
    }

    public boolean isViewMetadataFaceletCached(URL url) {
        Util.notNull((String)"url", (Object)url);
        return this._metadataFaceletCache.containsKey((Object)url);
    }

    private void _unwrapIOException(ExecutionException e) throws IOException {
        Throwable t = e.getCause();
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t.getCause() instanceof IOException) {
            throw (IOException)t.getCause();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new FacesException(t);
    }

    private static class NoCache
    extends ConcurrentCache<URL, Record> {
        public NoCache(ConcurrentCache.Factory<URL, Record> f) {
            super(f);
        }

        public Record get(URL key) throws ExecutionException {
            try {
                return (Record)this.getFactory().newInstance((Object)key);
            }
            catch (Exception e) {
                ExceptionUtils.checkInterrupt((Exception)e);
                throw new ExecutionException(e);
            }
        }

        public boolean containsKey(URL key) {
            return false;
        }
    }

    private static class NeverExpired
    implements ExpiringConcurrentCache.ExpiryChecker<URL, Record> {
        private NeverExpired() {
        }

        public boolean isExpired(URL key, Record value) {
            return false;
        }
    }

    private static class ExpiryChecker
    implements ExpiringConcurrentCache.ExpiryChecker<URL, Record> {
        private ExpiryChecker() {
        }

        public boolean isExpired(URL url, Record record) {
            long ttl = record.getNextRefreshTime();
            if (System.currentTimeMillis() > ttl) {
                long lastModified = Util.getLastModified((URL)url);
                return lastModified > record.getLastModified();
            }
            return false;
        }
    }

    private static class Record {
        private final long _lastModified;
        private final long _refreshInterval;
        private final long _creationTime;
        private final AtomicLong _nextRefreshTime;
        private final Facelet _facelet;

        Record(long creationTime, long lastModified, Facelet facelet, long refreshInterval) {
            this._facelet = facelet;
            this._creationTime = creationTime;
            this._lastModified = lastModified;
            this._refreshInterval = refreshInterval;
            this._nextRefreshTime = this._refreshInterval > 0L ? new AtomicLong(creationTime + refreshInterval) : null;
        }

        Facelet getFacelet() {
            return this._facelet;
        }

        long getLastModified() {
            return this._lastModified;
        }

        long getNextRefreshTime() {
            return this._refreshInterval > 0L ? this._nextRefreshTime.longValue() : 0L;
        }
    }
}

