/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.jsf;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayout;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderChangedListener;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class ContentViewImpl
implements ContentView,
PageProviderChangedListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ContentViewImpl.class);
    protected String name;
    protected PageProvider<?> pageProvider;
    protected String title;
    protected boolean translateTitle;
    protected String emptySentence;
    protected boolean translateEmptySentence;
    protected String iconPath;
    protected boolean showTitle;
    protected String selectionList;
    protected String pagination;
    protected List<String> actionCategories;
    protected ContentViewLayout searchLayout;
    protected List<ContentViewLayout> resultLayouts;
    protected List<String> flags;
    protected boolean currentResultLayoutSet = false;
    protected ContentViewLayout currentResultLayout;
    protected List<String> currentResultLayoutColumns;
    protected String cacheKey;
    protected Integer cacheSize;
    protected List<String> refreshEventNames;
    protected List<String> resetEventNames;
    protected boolean useGlobalPageSize;
    protected boolean showPageSizeSelector;
    protected boolean showRefreshCommand;
    protected boolean showFilterForm;
    protected Long currentPageSize;
    protected String[] queryParameters;
    protected DocumentModel searchDocumentModel;
    protected String searchDocumentModelBinding;
    protected String searchDocumentModelType;
    protected String resultColumnsBinding;
    protected String resultLayoutBinding;
    protected String pageSizeBinding;
    protected String sortInfosBinding;
    protected boolean waitForExecution = false;
    protected String waitForExecutionSentence;
    protected boolean executed = false;
    protected List<QuickFilter> quickFilters;

    public ContentViewImpl(String name, String title, boolean translateTitle, String iconPath, String selectionList, String pagination, List<String> actionCategories, ContentViewLayout searchLayout, List<ContentViewLayout> resultLayouts, List<String> flags, String cacheKey, Integer cacheSize, List<String> refreshEventNames, List<String> resetEventNames, boolean useGlobalPageSize, String[] queryParameters, String searchDocumentModelBinding, String searchDocumentModelType, String resultColumnsBinding, String resultLayoutBinding, String sortInfosBinding, String pageSizeBinding, boolean showTitle, boolean showPageSizeSelector, boolean showRefreshCommand, boolean showFilterForm, String emptySentence, boolean translateEmptySentence) {
        this.name = name;
        this.title = title;
        this.translateTitle = translateTitle;
        this.iconPath = iconPath;
        this.selectionList = selectionList;
        this.pagination = pagination;
        this.actionCategories = actionCategories;
        this.searchLayout = searchLayout;
        this.resultLayouts = resultLayouts;
        this.flags = flags;
        this.cacheKey = cacheKey;
        this.cacheSize = cacheSize;
        if (cacheSize != null && cacheSize <= 0) {
            this.cacheKey = "static_key_no_cache";
        }
        this.refreshEventNames = refreshEventNames;
        this.resetEventNames = resetEventNames;
        this.useGlobalPageSize = useGlobalPageSize;
        this.queryParameters = queryParameters;
        this.searchDocumentModelBinding = searchDocumentModelBinding;
        this.searchDocumentModelType = searchDocumentModelType;
        this.resultColumnsBinding = resultColumnsBinding;
        this.resultLayoutBinding = resultLayoutBinding;
        this.pageSizeBinding = pageSizeBinding;
        this.sortInfosBinding = sortInfosBinding;
        this.showTitle = showTitle;
        this.showPageSizeSelector = showPageSizeSelector;
        this.showRefreshCommand = showRefreshCommand;
        this.showFilterForm = showFilterForm;
        this.emptySentence = emptySentence;
        this.translateEmptySentence = translateEmptySentence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean getTranslateTitle() {
        return this.translateTitle;
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public String getSelectionListName() {
        return this.selectionList;
    }

    @Override
    public String getPagination() {
        return this.pagination;
    }

    @Override
    public List<String> getActionsCategories() {
        return this.actionCategories;
    }

    @Override
    public ContentViewLayout getSearchLayout() {
        return this.searchLayout;
    }

    @Override
    public List<ContentViewLayout> getResultLayouts() {
        return this.resultLayouts;
    }

    @Override
    public ContentViewLayout getCurrentResultLayout() {
        Object res;
        if (!this.currentResultLayoutSet && !StringUtils.isBlank((CharSequence)this.resultLayoutBinding) && (res = this.resolveWithSearchDocument((Function<FacesContext, Object>)((Function)ctx -> ComponentTagUtils.resolveElExpression((FacesContext)ctx, (String)this.resultLayoutBinding)))) != null && res instanceof String) {
            this.setCurrentResultLayout((String)res);
            this.currentResultLayoutSet = true;
        }
        if (this.currentResultLayout == null && this.resultLayouts != null && !this.resultLayouts.isEmpty()) {
            return this.resultLayouts.get(0);
        }
        return this.currentResultLayout;
    }

    @Override
    public void setCurrentResultLayout(ContentViewLayout layout) {
        this.setCurrentResultLayout(layout, true);
    }

    public void setCurrentResultLayout(ContentViewLayout layout, boolean resetLayoutColumn) {
        if (!StringUtils.isBlank((CharSequence)this.resultLayoutBinding) && ComponentTagUtils.isStrictValueReference((String)this.resultLayoutBinding)) {
            this.resolveWithSearchDocument((Function<FacesContext, Object>)((Function)ctx -> {
                ComponentTagUtils.applyValueExpression((FacesContext)ctx, (String)this.resultLayoutBinding, (Object)(layout == null ? null : layout.getName()));
                return null;
            }));
        }
        this.currentResultLayoutSet = true;
        this.currentResultLayout = layout;
        if (resetLayoutColumn) {
            this.setCurrentResultLayoutColumns(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object resolveWithSearchDocument(Function<FacesContext, Object> func) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (this.getSearchDocumentModel() == null) {
            return func.apply((Object)ctx);
        }
        Object previousSearchDocValue = this.addSearchDocumentToELContext(ctx);
        try {
            Object object = func.apply((Object)ctx);
            return object;
        }
        finally {
            this.removeSearchDocumentFromELContext(ctx, previousSearchDocValue);
        }
    }

    @Override
    public void setCurrentResultLayout(String resultLayoutName) {
        if (resultLayoutName != null) {
            for (ContentViewLayout layout : this.resultLayouts) {
                if (!resultLayoutName.equals(layout.getName())) continue;
                this.setCurrentResultLayout(layout, false);
            }
        }
    }

    @Override
    public boolean hasResultLayoutBinding() {
        return !StringUtils.isBlank((CharSequence)this.resultLayoutBinding);
    }

    @Override
    public PageProvider<?> getPageProvider(DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Object ... params) {
        if (this.isWaitForExecution() && !this.isExecuted()) {
            return null;
        }
        boolean setSearchDoc = false;
        DocumentModel finalSearchDocument = null;
        if (searchDocument != null) {
            setSearchDoc = true;
            finalSearchDocument = searchDocument;
        } else if (this.searchDocumentModel == null) {
            setSearchDoc = true;
            if (this.pageProvider != null) {
                finalSearchDocument = this.pageProvider.getSearchDocumentModel();
            }
            if (finalSearchDocument == null) {
                finalSearchDocument = this.getSearchDocumentModel();
                setSearchDoc = false;
            }
        } else {
            finalSearchDocument = this.searchDocumentModel;
        }
        if (setSearchDoc) {
            this.setSearchDocumentModel(finalSearchDocument);
        }
        if (params == null) {
            params = this.getQueryParameters();
        }
        if (sortInfos == null) {
            sortInfos = this.resolveSortInfos();
        }
        if (pageSize != null && pageSize < 0L) {
            pageSize = null;
        }
        if (currentPage != null && currentPage < 0L) {
            currentPage = null;
        }
        if (pageSize == null) {
            if (this.currentPageSize != null && this.currentPageSize >= 0L) {
                pageSize = this.currentPageSize;
            }
            if (pageSize == null) {
                pageSize = this.resolvePageSize();
            }
        }
        if (this.pageProvider == null || this.pageProvider.hasChangedParameters(params)) {
            ContentViewService service = (ContentViewService)Framework.getService(ContentViewService.class);
            this.pageProvider = service.getPageProvider(this.getName(), sortInfos, pageSize, currentPage, finalSearchDocument, params);
        } else {
            if (pageSize != null) {
                this.pageProvider.setPageSize(pageSize.longValue());
            }
            if (currentPage != null) {
                this.pageProvider.setCurrentPage(currentPage.longValue());
            }
        }
        this.pageProvider.setQuickFilters(new ArrayList());
        this.pageProvider.setPageProviderChangedListener((PageProviderChangedListener)this);
        return this.pageProvider;
    }

    @Override
    public PageProvider<?> getPageProviderWithParams(Object ... params) {
        return this.getPageProvider(null, null, null, null, params);
    }

    @Override
    public PageProvider<?> getPageProvider() {
        return this.getPageProviderWithParams(null);
    }

    @Override
    public PageProvider<?> getCurrentPageProvider() {
        return this.pageProvider;
    }

    @Override
    public void resetPageProvider() {
        this.pageProvider = null;
    }

    @Override
    public void refreshPageProvider() {
        if (this.pageProvider != null) {
            this.pageProvider.refresh();
        }
        this.setExecuted(true);
    }

    @Override
    public void refreshAndRewindPageProvider() {
        if (this.pageProvider != null) {
            this.pageProvider.refresh();
            this.pageProvider.firstPage();
        }
        this.setExecuted(true);
    }

    @Override
    public String getCacheKey() {
        FacesContext context = FacesContext.getCurrentInstance();
        Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.cacheKey);
        if (value != null && !(value instanceof String)) {
            log.error((Object)("Error processing expression '" + this.cacheKey + "', result is not a String: " + value));
        }
        return (String)value;
    }

    @Override
    public Integer getCacheSize() {
        return this.cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getQueryParameters() {
        if (this.queryParameters == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Object previousSearchDocValue = this.addSearchDocumentToELContext(context);
        try {
            Object[] res = new Object[this.queryParameters.length];
            for (int i = 0; i < this.queryParameters.length; ++i) {
                res[i] = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.queryParameters[i]);
            }
            Object[] objectArray = res;
            return objectArray;
        }
        finally {
            this.removeSearchDocumentFromELContext(context, previousSearchDocValue);
        }
    }

    @Override
    public List<String> getRefreshEventNames() {
        return this.refreshEventNames;
    }

    @Override
    public List<String> getResetEventNames() {
        return this.resetEventNames;
    }

    @Override
    public boolean getUseGlobalPageSize() {
        return this.useGlobalPageSize;
    }

    @Override
    public Long getCurrentPageSize() {
        if (this.pageProvider != null) {
            long pageSize = this.pageProvider.getPageSize();
            long maxPageSize = this.pageProvider.getMaxPageSize();
            if (pageSize > 0L && maxPageSize > 0L && maxPageSize < pageSize) {
                return maxPageSize;
            }
            return pageSize;
        }
        if (this.currentPageSize != null && this.currentPageSize >= 0L) {
            return this.currentPageSize;
        }
        return null;
    }

    @Override
    public void setCurrentPageSize(Long pageSize) {
        this.currentPageSize = pageSize;
        this.raiseEvent("contentViewPageSizeChanged");
    }

    @Override
    public DocumentModel getSearchDocumentModel() {
        if (this.searchDocumentModel == null) {
            String docType;
            if (this.searchDocumentModelBinding != null) {
                FacesContext context = FacesContext.getCurrentInstance();
                Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.searchDocumentModelBinding);
                if (value != null && !(value instanceof DocumentModel)) {
                    log.error((Object)("Error processing expression '" + this.searchDocumentModelBinding + "', result is not a DocumentModel: " + value));
                } else {
                    this.setSearchDocumentModel((DocumentModel)value);
                }
            }
            if (this.searchDocumentModel == null && (docType = this.getSearchDocumentModelType()) != null) {
                DocumentModelImpl bareDoc = DocumentModelFactory.createDocumentModel((String)docType);
                this.setSearchDocumentModel((DocumentModel)bareDoc);
            }
        }
        return this.searchDocumentModel;
    }

    @Override
    public void setSearchDocumentModel(DocumentModel searchDocumentModel) {
        this.searchDocumentModel = searchDocumentModel;
        if (this.pageProvider != null) {
            this.pageProvider.setSearchDocumentModel(searchDocumentModel);
        }
    }

    @Override
    public void resetSearchDocumentModel() {
        this.searchDocumentModel = null;
        if (this.pageProvider != null) {
            this.pageProvider.setSearchDocumentModel(null);
        }
    }

    @Override
    public String getSearchDocumentModelType() {
        return this.searchDocumentModelType;
    }

    @Override
    public List<String> getFlags() {
        return this.flags;
    }

    @Override
    public List<String> getCurrentResultLayoutColumns() {
        Object res;
        if (!StringUtils.isBlank((CharSequence)this.resultColumnsBinding) && (res = this.resolveWithSearchDocument((Function<FacesContext, Object>)((Function)ctx -> {
            Object value = ComponentTagUtils.resolveElExpression((FacesContext)ctx, (String)this.resultColumnsBinding);
            if (value != null && !(value instanceof List)) {
                log.error((Object)("Error processing expression '" + this.resultColumnsBinding + "', result is not a List: " + value));
            }
            return value;
        }))) != null && res instanceof List) {
            return ((List)res).isEmpty() ? null : (List)res;
        }
        return this.currentResultLayoutColumns;
    }

    @Override
    public void setCurrentResultLayoutColumns(List<String> resultColumns) {
        if (StringUtils.isBlank((CharSequence)this.resultColumnsBinding) || !ComponentTagUtils.isStrictValueReference((String)this.resultColumnsBinding)) {
            this.currentResultLayoutColumns = resultColumns;
        } else {
            this.resolveWithSearchDocument((Function<FacesContext, Object>)((Function)ctx -> {
                ComponentTagUtils.applyValueExpression((FacesContext)ctx, (String)this.resultColumnsBinding, (Object)resultColumns);
                return null;
            }));
        }
    }

    @Override
    public boolean hasResultLayoutColumnsBinding() {
        return !StringUtils.isBlank((CharSequence)this.resultColumnsBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SortInfo> resolveSortInfos() {
        if (this.sortInfosBinding == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Object previousSearchDocValue = this.addSearchDocumentToELContext(context);
        try {
            Object object;
            Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.sortInfosBinding);
            if (value != null && !(value instanceof List)) {
                log.error((Object)("Error processing expression '" + this.sortInfosBinding + "', result is not a List: '" + value + "'"));
            }
            if (value == null) {
                List<SortInfo> list = null;
                return list;
            }
            ArrayList<SortInfo> res = new ArrayList<SortInfo>();
            List listValue = (List)value;
            for (Object listItem : listValue) {
                if (listItem instanceof SortInfo) {
                    res.add((SortInfo)listItem);
                    continue;
                }
                if (listItem instanceof Map) {
                    Map map;
                    SortInfo sortInfo;
                    if (listItem instanceof MapProperty) {
                        try {
                            listItem = ((MapProperty)listItem).getValue();
                        }
                        catch (ClassCastException | PropertyException e) {
                            log.error((Object)("Cannot resolve sort info item: " + listItem), e);
                        }
                    }
                    if ((sortInfo = SortInfo.asSortInfo((Map)(map = (Map)listItem))) != null) {
                        res.add(sortInfo);
                        continue;
                    }
                    log.error((Object)("Cannot resolve sort info item: " + listItem));
                    continue;
                }
                log.error((Object)("Cannot resolve sort info item: " + listItem));
            }
            if (res.isEmpty()) {
                object = null;
                return object;
            }
            object = res;
            return object;
        }
        finally {
            this.removeSearchDocumentFromELContext(context, previousSearchDocValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Long resolvePageSize() {
        if (this.pageSizeBinding == null) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Object previousSearchDocValue = this.addSearchDocumentToELContext(context);
        try {
            Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)this.pageSizeBinding);
            if (value == null) {
                Long l = null;
                return l;
            }
            if (value instanceof String) {
                try {
                    Long l = Long.valueOf((String)value);
                    return l;
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Error processing expression '" + this.pageSizeBinding + "', result is not a Long: '" + value + "'"));
                }
            } else if (value instanceof Number) {
                Long l = ((Number)value).longValue();
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            this.removeSearchDocumentFromELContext(context, previousSearchDocValue);
        }
    }

    protected Object addSearchDocumentToELContext(FacesContext facesContext) {
        ExternalContext econtext = null;
        if (facesContext != null) {
            econtext = facesContext.getExternalContext();
        }
        if (facesContext == null || econtext == null) {
            log.error((Object)("JSF context is null: cannot expose variable 'searchDocument' for content view '" + this.getName() + "'"));
            return null;
        }
        Map requestMap = econtext.getRequestMap();
        Object previousValue = requestMap.get("searchDocument");
        requestMap.put("searchDocument", this.searchDocumentModel);
        return previousValue;
    }

    protected void removeSearchDocumentFromELContext(FacesContext facesContext, Object previousValue) {
        if (facesContext == null) {
            return;
        }
        ExternalContext econtext = facesContext.getExternalContext();
        if (econtext != null) {
            Map requestMap = econtext.getRequestMap();
            requestMap.remove("searchDocument");
            if (previousValue != null) {
                requestMap.put("searchDocument", previousValue);
            }
        } else {
            log.error((Object)("External context is null: cannot dispose variable 'searchDocument' for content view '" + this.getName() + "'"));
        }
    }

    @Override
    public boolean getShowPageSizeSelector() {
        return this.showPageSizeSelector;
    }

    @Override
    public boolean getShowRefreshCommand() {
        return this.showRefreshCommand;
    }

    @Override
    public boolean getShowFilterForm() {
        return this.showFilterForm;
    }

    @Override
    public boolean getShowTitle() {
        return this.showTitle;
    }

    @Override
    public String getEmptySentence() {
        return this.emptySentence;
    }

    @Override
    public boolean getTranslateEmptySentence() {
        return this.translateEmptySentence;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ContentViewImpl").append(" {").append(" name=").append(this.name).append(", title=").append(this.title).append(", translateTitle=").append(this.translateTitle).append(", iconPath=").append(this.iconPath).append(", selectionList=").append(this.selectionList).append(", pagination=").append(this.pagination).append(", actionCategories=").append(this.actionCategories).append(", searchLayout=").append(this.searchLayout).append(", resultLayouts=").append(this.resultLayouts).append(", currentResultLayout=").append(this.currentResultLayout).append(", flags=").append(this.flags).append(", cacheKey=").append(this.cacheKey).append(", cacheSize=").append(this.cacheSize).append(", currentPageSize=").append(this.currentPageSize).append(", refreshEventNames=").append(this.refreshEventNames).append(", resetEventNames=").append(this.resetEventNames).append(", useGlobalPageSize=").append(this.useGlobalPageSize).append(", searchDocumentModel=").append(this.searchDocumentModel).append('}');
        return buf.toString();
    }

    protected void raiseEvent(String eventName, Object ... params) {
        if (Events.exists()) {
            Events.instance().raiseEvent(eventName, params);
        }
    }

    protected void raiseEvent(String eventName) {
        this.raiseEvent(eventName, this.name);
    }

    public void pageChanged(PageProvider<?> pageProvider) {
        this.raiseEvent("contentViewPageChanged");
    }

    public void refreshed(PageProvider<?> pageProvider) {
        this.raiseEvent("contentViewRefresh");
    }

    @Override
    public void resetPageProviderAggregates() {
        if (this.pageProvider != null && this.pageProvider.hasAggregateSupport()) {
            Map aggs = this.pageProvider.getAggregates();
            for (Aggregate agg : aggs.values()) {
                agg.resetSelection();
            }
        }
    }

    @Override
    public String getWaitForExecutionSentence() {
        return this.waitForExecutionSentence;
    }

    public void setWaitForExecutionSentence(String waitForExecutionSentence) {
        this.waitForExecutionSentence = waitForExecutionSentence;
    }

    @Override
    public boolean isWaitForExecution() {
        return this.waitForExecution;
    }

    public void setWaitForExecution(boolean waitForExecution) {
        this.waitForExecution = waitForExecution;
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    @Override
    public void setQuickFilters(List<QuickFilter> quickFilters) {
        this.quickFilters = quickFilters;
    }

    @Override
    public List<QuickFilter> getQuickFilters() {
        return this.quickFilters;
    }
}

