/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import javax.faces.context.FacesContext;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.pdf.ui.UIChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;

public abstract class UICategoryChartBase
extends UIChart {
    private static Log log = Logging.getLog(UICategoryChartBase.class);
    private String orientation;
    private String titleBackgroundPaint;
    private String titlePaint;
    private String legendBackgroundPaint;
    private String legendItemPaint;
    private String legendOutlinePaint;
    private String domainAxisLabel;
    private String domainLabelPosition;
    private String domainAxisPaint;
    private Boolean domainGridlinesVisible;
    private String domainGridlinePaint;
    private String domainGridlineStroke;
    private String rangeAxisLabel;
    private String rangeAxisPaint;
    private Boolean rangeGridlinesVisible;
    private String rangeGridlinePaint;
    private String rangeGridlineStroke;

    public String getDomainAxisLabel() {
        return (String)this.valueBinding("domainAxisLabel", this.domainAxisLabel);
    }

    public void setDomainAxisLabel(String categoryAxisLabel) {
        this.domainAxisLabel = categoryAxisLabel;
    }

    public String getRangeAxisLabel() {
        return (String)this.valueBinding("rangeAxisLabel", this.rangeAxisLabel);
    }

    public void setRangeAxisLabel(String valueAxisLabel) {
        this.rangeAxisLabel = valueAxisLabel;
    }

    public String getDomainLabelPosition() {
        return (String)this.valueBinding("domainLabelPosition", this.domainLabelPosition);
    }

    public void setDomainLabelPosition(String domainLabelPosition) {
        this.domainLabelPosition = domainLabelPosition;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public String getOrientation() {
        return (String)this.valueBinding("orientation", this.orientation);
    }

    public void setTitleBackgroundPaint(String titleBackgroundPaint) {
        this.titleBackgroundPaint = titleBackgroundPaint;
    }

    public String getTitleBackgroundPaint() {
        return (String)this.valueBinding("titleBackgroundPaint", this.titleBackgroundPaint);
    }

    public void setTitlePaint(String titlePaint) {
        this.titlePaint = titlePaint;
    }

    public String getTitlePaint() {
        return (String)this.valueBinding("titlePaint", this.titlePaint);
    }

    public String getLegendBackgroundPaint() {
        return (String)this.valueBinding("legendBackgroundPaint", this.legendBackgroundPaint);
    }

    public void setLegendBackgroundPaint(String legendBackgroundPaint) {
        this.legendBackgroundPaint = legendBackgroundPaint;
    }

    public String getLegendItemPaint() {
        return (String)this.valueBinding("legendItemPaint", this.legendItemPaint);
    }

    public void setLegendItemPaint(String legendItemPaint) {
        this.legendItemPaint = legendItemPaint;
    }

    public String getLegendOutlinePaint() {
        return (String)this.valueBinding("legendOutlinePaint", this.legendOutlinePaint);
    }

    public void setLegendOutlinePaint(String legendOutlinePaint) {
        this.legendOutlinePaint = legendOutlinePaint;
    }

    public String getDomainGridlinePaint() {
        return (String)this.valueBinding("domainGridlinePaint", this.domainGridlinePaint);
    }

    public void setDomainGridlinePaint(String domainGridlinePaint) {
        this.domainGridlinePaint = domainGridlinePaint;
    }

    public String getDomainGridlineStroke() {
        return (String)this.valueBinding("domainGridlineStroke", this.domainGridlineStroke);
    }

    public void setDomainGridlineStroke(String domainGridlineStroke) {
        this.domainGridlineStroke = domainGridlineStroke;
    }

    public Boolean getDomainGridlinesVisible() {
        return (Boolean)this.valueBinding("domainGridlinesVisible", this.domainGridlinesVisible);
    }

    public void setDomainGridlinesVisible(Boolean domainGridlinesVisible) {
        this.domainGridlinesVisible = domainGridlinesVisible;
    }

    public String getRangeGridlinePaint() {
        return (String)this.valueBinding("rangeGridlinePaint", this.rangeGridlinePaint);
    }

    public void setRangeGridlinePaint(String rangeGridlinePaint) {
        this.rangeGridlinePaint = rangeGridlinePaint;
    }

    public String getRangeGridlineStroke() {
        return (String)this.valueBinding("rangeGridlineStroke", this.rangeGridlineStroke);
    }

    public void setRangeGridlineStroke(String rangeGridlineStroke) {
        this.rangeGridlineStroke = rangeGridlineStroke;
    }

    public Boolean getRangeGridlinesVisible() {
        return (Boolean)this.valueBinding("rangeGridlinesVisible", this.rangeGridlinesVisible);
    }

    public void setRangeGridlinesVisible(Boolean rangeGridlinesVisible) {
        this.rangeGridlinesVisible = rangeGridlinesVisible;
    }

    public String getDomainAxisPaint() {
        return (String)this.valueBinding("domainAxisPaint", this.domainAxisPaint);
    }

    public void setDomainAxisPaint(String domainAxisPaint) {
        this.domainAxisPaint = domainAxisPaint;
    }

    public String getRangeAxisPaint() {
        return (String)this.valueBinding("rangeAxisPaint", this.rangeAxisPaint);
    }

    public void setRangeAxisPaint(String rangeAxisPaint) {
        this.rangeAxisPaint = rangeAxisPaint;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.orientation = (String)values[1];
        this.titleBackgroundPaint = (String)values[5];
        this.titlePaint = (String)values[6];
        this.legendBackgroundPaint = (String)values[7];
        this.legendItemPaint = (String)values[8];
        this.legendOutlinePaint = (String)values[9];
        this.domainAxisLabel = (String)values[10];
        this.domainAxisPaint = (String)values[11];
        this.domainGridlinesVisible = (Boolean)values[12];
        this.domainGridlinePaint = (String)values[13];
        this.domainGridlineStroke = (String)values[14];
        this.rangeAxisLabel = (String)values[15];
        this.rangeAxisPaint = (String)values[16];
        this.rangeGridlinesVisible = (Boolean)values[17];
        this.rangeGridlinePaint = (String)values[18];
        this.rangeGridlineStroke = (String)values[19];
        this.domainLabelPosition = (String)values[20];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[21];
        values[0] = super.saveState(context);
        values[1] = this.orientation;
        values[5] = this.titleBackgroundPaint;
        values[6] = this.titlePaint;
        values[7] = this.legendBackgroundPaint;
        values[8] = this.legendItemPaint;
        values[9] = this.legendOutlinePaint;
        values[10] = this.domainAxisLabel;
        values[11] = this.domainAxisPaint;
        values[12] = this.domainGridlinesVisible;
        values[13] = this.domainGridlinePaint;
        values[14] = this.domainGridlineStroke;
        values[15] = this.rangeAxisLabel;
        values[16] = this.rangeAxisPaint;
        values[17] = this.rangeGridlinesVisible;
        values[18] = this.rangeGridlinePaint;
        values[19] = this.rangeGridlineStroke;
        values[20] = this.domainLabelPosition;
        return values;
    }

    @Override
    public void configurePlot(Plot plot) {
        super.configurePlot(plot);
        if (plot instanceof CategoryPlot) {
            this.configurePlot((CategoryPlot)plot);
        } else {
            log.error((Object)("UICATEGORYCHART --- unknown plot " + plot), new Object[0]);
        }
    }

    public void configurePlot(CategoryPlot plot) {
        if (this.getDomainGridlinesVisible() != null) {
            plot.setDomainGridlinesVisible(this.getDomainGridlinesVisible().booleanValue());
        }
        if (UICategoryChartBase.findColor(this.getDomainGridlinePaint()) != null) {
            plot.setDomainGridlinePaint(UICategoryChartBase.findColor(this.getDomainGridlinePaint()));
        }
        if (UICategoryChartBase.findStroke(this.getDomainGridlineStroke()) != null) {
            plot.setDomainGridlineStroke(UICategoryChartBase.findStroke(this.getDomainGridlineStroke()));
        }
        if (UICategoryChartBase.findColor(this.getDomainAxisPaint()) != null) {
            plot.getDomainAxis().setLabelPaint(UICategoryChartBase.findColor(this.getDomainAxisPaint()));
        }
        if (this.getRangeGridlinesVisible() != null) {
            plot.setRangeGridlinesVisible(this.getRangeGridlinesVisible().booleanValue());
        }
        if (UICategoryChartBase.findColor(this.getRangeGridlinePaint()) != null) {
            plot.setRangeGridlinePaint(UICategoryChartBase.findColor(this.getRangeGridlinePaint()));
        }
        if (UICategoryChartBase.findStroke(this.getRangeGridlineStroke()) != null) {
            plot.setRangeGridlineStroke(UICategoryChartBase.findStroke(this.getRangeGridlineStroke()));
        }
        if (UICategoryChartBase.findColor(this.getRangeAxisPaint()) != null) {
            plot.getRangeAxis().setLabelPaint(UICategoryChartBase.findColor(this.getRangeAxisPaint()));
        }
        if (this.getDomainLabelPosition() != null) {
            CategoryLabelPositions positions = this.categoryLabelPosition(this.getDomainLabelPosition());
            plot.getDomainAxis().setCategoryLabelPositions(positions);
        }
        this.configureRenderer(plot.getRenderer());
    }

    private CategoryLabelPositions categoryLabelPosition(String position) {
        if (position == null) {
            return CategoryLabelPositions.STANDARD;
        }
        if (position.equals("UP_45")) {
            return CategoryLabelPositions.UP_45;
        }
        if (position.equals("UP_90")) {
            return CategoryLabelPositions.UP_90;
        }
        if (position.equals("DOWN_45")) {
            return CategoryLabelPositions.DOWN_45;
        }
        if (position.equals("DOWN_90")) {
            return CategoryLabelPositions.DOWN_90;
        }
        double angle = Double.parseDouble(position);
        if (angle > 0.0) {
            return CategoryLabelPositions.createUpRotationLabelPositions((double)angle);
        }
        return CategoryLabelPositions.createDownRotationLabelPositions((double)(-angle));
    }

    public void configureRenderer(CategoryItemRenderer renderer) {
    }

    public void configureTitle(TextTitle chartTitle) {
        if (chartTitle != null) {
            if (UICategoryChartBase.findColor(this.getTitleBackgroundPaint()) != null) {
                chartTitle.setBackgroundPaint(UICategoryChartBase.findColor(this.getTitleBackgroundPaint()));
            }
            if (UICategoryChartBase.findColor(this.getTitlePaint()) != null) {
                chartTitle.setPaint(UICategoryChartBase.findColor(this.getTitlePaint()));
            }
        }
    }

    void configureLegend(LegendTitle chartLegend) {
        if (chartLegend != null) {
            if (UICategoryChartBase.findColor(this.getLegendBackgroundPaint()) != null) {
                chartLegend.setBackgroundPaint(UICategoryChartBase.findColor(this.getLegendBackgroundPaint()));
            }
            if (UICategoryChartBase.findColor(this.getLegendOutlinePaint()) != null) {
                chartLegend.setFrame((BlockFrame)new BlockBorder(UICategoryChartBase.findColor(this.getLegendOutlinePaint())));
            }
            if (UICategoryChartBase.findColor(this.getLegendItemPaint()) != null) {
                chartLegend.setItemPaint(UICategoryChartBase.findColor(this.getLegendItemPaint()));
            }
        }
    }
}

