/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.convert;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;
import org.nuxeo.ecm.platform.threed.convert.DockerHelper;
import org.nuxeo.runtime.api.Framework;

public class Collada2glTFConverter
extends CommandLineBasedConverter {
    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        return null;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        return null;
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String dataContainer = "data" + String.valueOf(Calendar.getInstance().getTime().getTime());
        String convertContainer = "convert" + String.valueOf(Calendar.getInstance().getTime().getTime());
        String commandName = this.getCommandName(blobHolder, parameters);
        if (commandName == null) {
            throw new ConversionException("Unable to determine target CommandLine name");
        }
        CmdParameters params = new CmdParameters();
        List<Object> filesToDelete = new ArrayList();
        try {
            Path directory = new Path(this.getTmpDirectory(parameters)).append("dae2gltf_" + UUID.randomUUID() + "_in");
            boolean dirCreated = new File(directory.toString()).mkdirs();
            if (!dirCreated) {
                throw new ConversionException("Unable to create tmp dir: " + directory);
            }
            List blobs = blobHolder.getBlobs();
            filesToDelete = blobs.stream().map(blob -> {
                File file = new File(directory.append(blob.getFilename()).toString());
                try {
                    blob.transferTo(file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return file.getAbsolutePath();
            }).collect(Collectors.toList());
            Path inputFile = new Path((String)filesToDelete.get(0));
            params.addNamedParameter("inFile", inputFile.lastSegment());
            ExecResult createRes = DockerHelper.CreateContainer(dataContainer, "nuxeo/collada2gltf");
            if (createRes == null || !createRes.isSuccessful()) {
                throw new ConversionException("Unable to create data volume : " + dataContainer, (Throwable)(createRes != null ? createRes.getError() : null));
            }
            ExecResult copyRes = DockerHelper.CopyData(inputFile.removeLastSegments(1).toString() + File.separatorChar + ".", dataContainer + ":/in/");
            if (copyRes == null || !copyRes.isSuccessful()) {
                throw new ConversionException("Unable to copy to data volume : " + dataContainer, (Throwable)(copyRes != null ? copyRes.getError() : null));
            }
            params.addNamedParameter("name", convertContainer);
            params.addNamedParameter("data", dataContainer);
            filesToDelete.add(directory.toString());
            String baseDir = this.getTmpDirectory(parameters);
            Path outPath = new Path(baseDir).append("dae2gltf_out_" + UUID.randomUUID() + "_out");
            File outDir = new File(outPath.toString());
            dirCreated = outDir.mkdir();
            if (!dirCreated) {
                throw new ConversionException("Unable to create tmp dir for transformer output: " + outDir);
            }
            params.addNamedParameter("outFile", inputFile.removeFileExtension().lastSegment() + ".gltf");
            params.addNamedParameter("outDir", outPath.toString());
            ExecResult result = ((CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class)).execCommand(commandName, params);
            if (!result.isSuccessful()) {
                throw result.getError();
            }
            copyRes = DockerHelper.CopyData(dataContainer + ":/out/.", outPath.toString());
            if (copyRes == null || !copyRes.isSuccessful()) {
                throw new ConversionException("Unable to copy from data volume : " + dataContainer, (Throwable)(copyRes != null ? copyRes.getError() : null));
            }
            BlobHolder blobHolder2 = this.buildResult(result.getOutput(), params);
            return blobHolder2;
        }
        catch (CommandNotAvailable e) {
            throw new ConversionException("Unable to find targetCommand", (Throwable)e);
        }
        catch (CommandException e) {
            throw new ConversionException("Error while converting via CommandLineService", (Throwable)e);
        }
        finally {
            for (String string : filesToDelete) {
                FileUtils.deleteQuietly((File)new File(string));
            }
            DockerHelper.RemoveContainer(dataContainer);
            DockerHelper.RemoveContainer(convertContainer);
        }
    }

    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParameters) throws ConversionException {
        File outputFile = new File(cmdParameters.getParameter("outDir") + File.separator + cmdParameters.getParameter("outFile"));
        ArrayList<FileBlob> blobs = new ArrayList<FileBlob>();
        blobs.add(new FileBlob(outputFile));
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("cmdOutput", (Serializable)((Object)cmdOutput));
        return new SimpleBlobHolderWithProperties(blobs, properties);
    }
}

