/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.richfaces.application.push.Session;

public final class SessionQueue {
    private static final Comparator<? super Session> SESSIONS_COMPARATOR = new Comparator<Session>(){

        @Override
        public int compare(Session o1, Session o2) {
            Long expTime1 = SessionQueue.getExpirationTime(o1);
            Long expTime2 = SessionQueue.getExpirationTime(o2);
            return expTime1.compareTo(expTime2);
        }
    };
    private final Queue<Session> queue = new PriorityQueue<Session>(1, SESSIONS_COMPARATOR);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition available = this.lock.newCondition();
    private boolean active = true;

    private static long getExpirationTime(Session session) {
        long lastAccessedTime = session.getLastAccessedTime();
        if (lastAccessedTime < 0L) {
            return Long.MIN_VALUE;
        }
        return lastAccessedTime + (long)session.getMaxInactiveInterval();
    }

    private long getDelay(Session session, TimeUnit unit) {
        long expirationTime = SessionQueue.getExpirationTime(session);
        if (expirationTime < 0L) {
            return Long.MIN_VALUE;
        }
        return unit.convert(expirationTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            block9: {
                while (this.active) {
                    Session first = this.queue.peek();
                    if (first == null) {
                        this.available.await();
                        continue;
                    }
                    long delay = this.getDelay(first, TimeUnit.NANOSECONDS);
                    if (delay > 0L) {
                        this.available.awaitNanos(delay);
                        continue;
                    }
                    break block9;
                }
                throw new InterruptedException("Session queue is stopping");
            }
            Session x = this.queue.poll();
            assert (x != null);
            if (this.queue.size() != 0) {
                this.available.signalAll();
            }
            Session session = x;
            return session;
        }
        finally {
            lock.unlock();
        }
    }

    public void remove(Session session) {
        ReentrantLock lock = this.lock;
        lock.lock();
        this.checkActiveState();
        try {
            this.queue.remove(session);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requeue(Session session, boolean addIfNotExists) {
        ReentrantLock lock = this.lock;
        lock.lock();
        this.checkActiveState();
        try {
            boolean exists = this.queue.remove(session);
            if (exists || addIfNotExists) {
                Session first = this.queue.peek();
                this.queue.offer(session);
                if (first == null || SESSIONS_COMPARATOR.compare(session, first) < 0) {
                    this.available.signalAll();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void checkActiveState() {
        if (!this.active) {
            throw new IllegalStateException("Queue is not active");
        }
    }

    public void shutdown() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.queue.clear();
            this.active = false;
            this.available.signalAll();
        }
        finally {
            lock.unlock();
        }
    }
}

