/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.scan.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.optimizer.resource.scan.ResourcesScanner;
import org.richfaces.resource.optimizer.resource.util.ResourceUtil;
import org.richfaces.resource.optimizer.vfs.VirtualFile;

public class StaticResourcesScanner
implements ResourcesScanner {
    private Collection<ResourceKey> resources = Sets.newHashSet();
    private Collection<VirtualFile> resourceRoots;

    public StaticResourcesScanner(Collection<VirtualFile> resourceRoots) {
        this.resourceRoots = resourceRoots;
    }

    private void scanResourcesRoot(VirtualFile file) {
        if (file == null) {
            return;
        }
        Collection<VirtualFile> children = file.getChildren();
        for (VirtualFile child : children) {
            if (child.isFile()) {
                this.resources.add(ResourceKey.create(child.getName()));
                continue;
            }
            String libraryName = child.getName();
            VirtualFile libraryDir = ResourceUtil.getLatestVersion(child, true);
            if (libraryDir == null) continue;
            this.scanLibrary(libraryName, "", libraryDir);
        }
    }

    private void scanLibrary(String libraryName, String resourceNamePrefix, VirtualFile dir) {
        Collection<VirtualFile> children = dir.getChildren();
        for (VirtualFile child : children) {
            String resourceName = resourceNamePrefix + child.getName();
            if (child.isFile()) {
                this.resources.add(new ResourceKey(resourceName, libraryName));
                continue;
            }
            if (!child.isDirectory()) continue;
            VirtualFile resource = ResourceUtil.getLatestVersion(child, false);
            if (resource != null) {
                this.resources.add(new ResourceKey(resourceName, libraryName));
                continue;
            }
            this.scanLibrary(libraryName, resourceName + "/", child);
        }
    }

    @Override
    public void scan() throws Exception {
        for (VirtualFile resourceRoot : this.resourceRoots) {
            this.scanResourcesRoot(resourceRoot);
        }
    }

    @Override
    public Collection<ResourceKey> getResources() {
        return this.resources;
    }
}

