/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.filemanager.core.listener.MimetypeIconUpdater;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.threed.BatchConverterHelper;
import org.nuxeo.ecm.platform.threed.ThreeD;
import org.nuxeo.ecm.platform.threed.ThreeDDocument;
import org.nuxeo.ecm.platform.threed.ThreeDInfo;
import org.nuxeo.ecm.platform.threed.ThreeDRenderView;
import org.nuxeo.ecm.platform.threed.TransmissionThreeD;
import org.nuxeo.ecm.platform.threed.service.RenderView;
import org.nuxeo.ecm.platform.threed.service.ThreeDService;
import org.nuxeo.runtime.api.Framework;

public class ThreeDBatchUpdateWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final String THREED_CHANGED_EVENT = "threeDEvent";
    private static final Log log = LogFactory.getLog(ThreeDBatchUpdateWork.class);
    public static final String CATEGORY_THREED_CONVERSION = "threeDConversion";
    public static final String THREED_CONVERSIONS_DONE_EVENT = "threeDConversionsDone";

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ':' + docId + ":threedbatch:";
    }

    public ThreeDBatchUpdateWork(String repositoryName, String docId) {
        super(ThreeDBatchUpdateWork.computeIdPrefix(repositoryName, docId));
        this.setDocument(repositoryName, docId);
    }

    public String getCategory() {
        return CATEGORY_THREED_CONVERSION;
    }

    public String getTitle() {
        return "3D preview batch update";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        BlobHolder batch;
        if (this.isWorkInstanceSuspended()) {
            return;
        }
        this.setStatus("Extracting");
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        ThreeD originalThreeD = null;
        try {
            this.openSystemSession();
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            originalThreeD = this.getThreeDToConvert(doc);
            this.commitOrRollbackTransaction();
        }
        finally {
            this.cleanUp(true, null);
        }
        if (originalThreeD == null) {
            this.setStatus("Nothing to process");
            return;
        }
        if (this.isWorkInstanceSuspended()) {
            return;
        }
        this.setStatus("Batch conversion");
        ThreeDService service = (ThreeDService)Framework.getService(ThreeDService.class);
        try {
            batch = service.batchConvert(originalThreeD);
        }
        catch (ConverterNotRegistered e) {
            return;
        }
        if (this.isWorkInstanceSuspended()) {
            return;
        }
        this.setStatus("Saving thumbnail");
        List<ThreeDRenderView> threeDRenderViews = BatchConverterHelper.getRenders(batch);
        long numRenderViews = service.getAutomaticRenderViews().stream().filter(RenderView::isEnabled).count();
        if (!threeDRenderViews.isEmpty() && (long)threeDRenderViews.size() == numRenderViews) {
            try {
                this.startTransaction();
                this.openSystemSession();
                DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
                this.saveNewRenderViews(doc, threeDRenderViews);
                this.commitOrRollbackTransaction();
            }
            finally {
                this.cleanUp(true, null);
            }
        }
        if (this.isWorkInstanceSuspended()) {
            return;
        }
        this.setStatus("Saving 3D information on main content");
        List<BlobHolder> resources = BatchConverterHelper.getResources(batch);
        ThreeDInfo mainInfo = BatchConverterHelper.getMainInfo(batch, resources);
        if (mainInfo != null) {
            try {
                this.startTransaction();
                this.openSystemSession();
                DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
                this.saveMainInfo(doc, mainInfo);
                this.commitOrRollbackTransaction();
            }
            finally {
                this.cleanUp(true, null);
            }
        }
        if (this.isWorkInstanceSuspended()) {
            return;
        }
        this.setStatus("Converting Collada to glTF");
        List<TransmissionThreeD> colladaThreeDs = BatchConverterHelper.getTransmissions(batch, resources);
        List<TransmissionThreeD> transmissionThreeDs = colladaThreeDs.stream().map(arg_0 -> ((ThreeDService)service).convertColladaToglTF(arg_0)).collect(Collectors.toList());
        if (this.isWorkInstanceSuspended()) {
            return;
        }
        this.setStatus("Saving transmission formats");
        this.startTransaction();
        this.openSystemSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        this.saveNewTransmissionThreeDs(doc, transmissionThreeDs);
        if (this.isWorkInstanceSuspended()) {
            return;
        }
        this.fireThreeDConversionsDoneEvent(doc);
        this.setStatus("Done");
    }

    protected ThreeD getThreeDToConvert(DocumentModel doc) {
        ThreeDDocument threedDocument = (ThreeDDocument)doc.getAdapter(ThreeDDocument.class);
        ThreeD threed = threedDocument.getThreeD();
        if (threed == null) {
            log.warn((Object)("No original 3d to process for: " + doc));
        }
        return threed;
    }

    protected void saveNewProperties(DocumentModel doc, Serializable properties, String schema) {
        doc.setPropertyValue(schema, properties);
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        this.session.saveDocument(doc);
    }

    protected void saveMainInfo(DocumentModel doc, ThreeDInfo info) {
        this.saveNewProperties(doc, (Serializable)((Object)info.toMap()), "threed:info");
    }

    protected void saveNewTransmissionThreeDs(DocumentModel doc, List<TransmissionThreeD> transmissionThreeDs) {
        ArrayList transmissionList = new ArrayList();
        transmissionList.addAll(transmissionThreeDs.stream().map(TransmissionThreeD::toMap).collect(Collectors.toList()));
        this.saveNewProperties(doc, transmissionList, "threed:transmissionFormats");
    }

    protected void saveNewRenderViews(DocumentModel doc, List<ThreeDRenderView> threeDRenderViews) {
        ArrayList renderViewList = new ArrayList();
        renderViewList.addAll(threeDRenderViews.stream().map(ThreeDRenderView::toMap).collect(Collectors.toList()));
        this.saveNewProperties(doc, renderViewList, "threed:renderViews");
    }

    protected void fireThreeDConversionsDoneEvent(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        List workIds = workManager.listWorkIds(CATEGORY_THREED_CONVERSION, null);
        String idPrefix = ThreeDBatchUpdateWork.computeIdPrefix(this.repositoryName, this.docId);
        int worksCount = 0;
        for (String workId : workIds) {
            if (!workId.startsWith(idPrefix) || ++worksCount <= 1) continue;
            return;
        }
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(THREED_CONVERSIONS_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
        MimetypeIconUpdater iconUpdater = new MimetypeIconUpdater();
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        MimetypeEntry mimeTypeEntry = mimetypeRegistry.getMimetypeEntryByMimeType("ThreeD");
        iconUpdater.updateIconField(mimeTypeEntry, doc);
    }
}

