/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.utils;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.generated.rss10.elements.UpdatePeriodEnum;

public class CommonUtils {
    private static final Log LOG = LogFactory.getLog(CommonUtils.class);
    public static final String RSS20_JAXB_CONTEXT = "yarfraw.generated.rss20.elements";
    public static final String RSS10_JAXB_CONTEXT = "yarfraw.generated.rss10.elements";
    public static final String ATOM10_JAXB_CONTEXT = "yarfraw.generated.atom10.elements";
    public static final String ATOM03_JAXB_CONTEXT = "yarfraw.generated.atom03.elements";
    public static final String RFC822DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String ISO8601DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String ISO_8601_LVL1_PATTERN = "yyyy";
    public static final String ISO_8601_LVL2_PATTERN = "yyyy-MM";
    public static final String ISO_8601_LVL3_PATTERN = "yyyy-MM-dd";
    public static final String ISO_8601_LVL4_PATTERN = "yyyy-MM-dd'T'HH:mmZ";
    public static final String ISO_8601_LVL5_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String ISO_8601_LVL6_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.sZ";
    public static final String NON_STANDARD_PATTERN1 = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String NON_STANDARD_PATTERN2 = "EEE, dd MMM yyyy HH:mm zzzz";
    public static final String NON_STANDARD_PATTERN3 = "EEE, dd MMM yy HH:mm:ss z";
    public static final String NON_STANDARD_PATTERN4 = "yyyy-MM-dd'T'HH:mm:ss.SSSzzzz";
    public static final String NON_STANDARD_PATTERN5 = "yyyy-MM-dd'T'HH:mm:sszzzz";
    public static final String NON_STANDARD_PATTERN6 = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String NON_STANDARD_PATTERN7 = "yyyy-MM-dd'T'HH:mm:ss.sZ";
    private static final SimpleDateFormat ISO_8601_LVL1 = new SimpleDateFormat("yyyy");
    private static final SimpleDateFormat ISO_8601_LVL2 = new SimpleDateFormat("yyyy-MM");
    private static final SimpleDateFormat ISO_8601_LVL3 = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat ISO_8601_LVL4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
    private static final SimpleDateFormat ISO_8601_LVL5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat ISO_8601_LVL6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sZ");
    private static final SimpleDateFormat RFC822DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final SimpleDateFormat[] RFC_FORMAT = new SimpleDateFormat[]{RFC822DATE_FORMAT, new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z"), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm zzzz"), new SimpleDateFormat("EEE, dd MMM yy HH:mm:ss z")};
    private static final SimpleDateFormat[] NON_STANDARD_ISO_FORMAT = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSzzzz"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzzz"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sZ")};

    private CommonUtils() {
    }

    public static synchronized boolean isDateFormatValid(String dateString, FeedFormat format) {
        if (format == FeedFormat.ATOM10 || format == FeedFormat.RSS10 || format == FeedFormat.ATOM03) {
            try {
                return CommonUtils.tryParseISODate(dateString) != null;
            }
            catch (Exception e) {
                return CommonUtils.tryParseNonStandardIsoDates(dateString) != null;
            }
        }
        if (format == FeedFormat.RSS20) {
            try {
                return CommonUtils.tryParseRfcDates(dateString) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IllegalArgumentException("Unsupported format: " + (Object)((Object)format));
    }

    private static String removeLast(String s, char c) {
        int idx = s.lastIndexOf(c);
        if (idx < 0) {
            return s;
        }
        return s.substring(0, idx) + (idx == s.length() - 1 ? "" : s.substring(idx + 1));
    }

    public static synchronized Date tryParseDate(String dateString) {
        Date ret = null;
        try {
            ret = CommonUtils.tryParseISODate(dateString);
            return ret;
        }
        catch (Exception e) {
            ret = CommonUtils.tryParseNonStandardIsoDates(dateString);
            if (ret != null) {
                return ret;
            }
            ret = CommonUtils.tryParseRfcDates(dateString);
            if (ret == null) {
                LOG.warn((Object)("Unparsable dateString " + dateString + ", returning null"));
            }
            return ret;
        }
    }

    private static Date tryParseRfcDates(String dateString) {
        Date ret = null;
        for (SimpleDateFormat format : RFC_FORMAT) {
            try {
                ret = format.parse(dateString);
                return ret;
            }
            catch (Exception ee) {
            }
        }
        return ret;
    }

    private static Date tryParseNonStandardIsoDates(String dateString) {
        Date ret = null;
        for (SimpleDateFormat format : NON_STANDARD_ISO_FORMAT) {
            try {
                ret = format.parse(dateString);
                return ret;
            }
            catch (Exception ee) {
            }
        }
        return ret;
    }

    public static synchronized String formatDate(Date date, FeedFormat format) {
        if (date == null || format == null) {
            return null;
        }
        if (format == FeedFormat.ATOM10 || format == FeedFormat.RSS20 || format == FeedFormat.ATOM03) {
            return CommonUtils.getDateAsISO8601String(date);
        }
        if (format == FeedFormat.RSS10) {
            return RFC822DATE_FORMAT.format(date);
        }
        throw new IllegalArgumentException("Unsupported format: " + (Object)((Object)format));
    }

    private static String getDateAsISO8601String(Date date) {
        if (date == null) {
            return null;
        }
        String result = ISO_8601_LVL5.format(date);
        result = result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
        return result;
    }

    private static synchronized Date tryParseISODate(String dateString) throws YarfrawException, ParseException {
        if (dateString == null) {
            return null;
        }
        if (dateString.length() == 4) {
            return ISO_8601_LVL1.parse(dateString);
        }
        if (dateString.length() == 7) {
            return ISO_8601_LVL2.parse(dateString);
        }
        if (dateString.length() == 10) {
            return ISO_8601_LVL3.parse(dateString);
        }
        if (dateString.length() == 22) {
            return ISO_8601_LVL4.parse(CommonUtils.removeLast(dateString, ':'));
        }
        if (dateString.length() == 25) {
            return ISO_8601_LVL5.parse(CommonUtils.removeLast(dateString, ':'));
        }
        if (dateString.length() == 28) {
            return ISO_8601_LVL6.parse(CommonUtils.removeLast(dateString, ':'));
        }
        throw new YarfrawException("Invalid ISO 8601 Date format: " + dateString);
    }

    public static Integer calculateTtl(UpdatePeriodEnum updatePeriod, BigInteger updateFrequency) {
        int freq;
        if (updatePeriod == null && updateFrequency == null) {
            return null;
        }
        int n = freq = updateFrequency == null ? 1 : updateFrequency.intValue();
        if (updatePeriod == UpdatePeriodEnum.HOURLY) {
            return Math.max(1, 60 / freq);
        }
        if (updatePeriod == UpdatePeriodEnum.DAILY) {
            return Math.max(1, 1440 / freq);
        }
        if (updatePeriod == UpdatePeriodEnum.MONTHLY) {
            return Math.max(1, 43200 / freq);
        }
        if (updatePeriod == UpdatePeriodEnum.WEEKLY) {
            return Math.max(1, 10080 / freq);
        }
        if (updatePeriod == UpdatePeriodEnum.YEARLY) {
            return Math.max(1, 525600 / freq);
        }
        return null;
    }
}

