/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.seam;

import com.sun.faces.config.WebConfiguration;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.ui.util.JSF;
import org.nuxeo.ecm.platform.ui.web.util.NXHtmlResponseWriter;

public class UICellExcel
extends UICell {
    private static final Log log = LogFactory.getLog(UICellExcel.class);
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_CHARACTER_ENCODING = "utf-8";
    protected Object value;
    protected String forceType;
    protected String style;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue() {
        Object theValue = this.valueOf("value", this.value);
        if (theValue != null) return theValue.toString();
        try {
            theValue = UICellExcel.cmp2String(FacesContext.getCurrentInstance(), (UIComponent)this);
            String forceType = this.getForceType();
            if (forceType == null) return theValue;
            if (forceType.isEmpty()) return theValue;
            return this.convertStringToTargetType((String)theValue, forceType);
        }
        catch (IOException e) {
            String message = Interpolator.instance().interpolate("Could not render cell #0", new Object[]{this.getId()});
            throw new ExcelWorkbookException(message, (Throwable)e);
        }
    }

    public void setValue(Object value) {
        this.value = value;
    }

    protected Object convertStringToTargetType(String value, String forceType) {
        if (UICell.CellType.number.name().equals(forceType)) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return Double.valueOf(value);
        }
        if (UICell.CellType.date.name().equals(forceType)) {
            int[] formats;
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            for (int format : formats = new int[]{3, 2, 1, 0}) {
                try {
                    return DateFormat.getDateTimeInstance(format, format, locale).parse(value);
                }
                catch (ParseException parseException) {
                    try {
                        return DateFormat.getDateInstance(format, locale).parse(value);
                    }
                    catch (ParseException parseException2) {
                    }
                }
            }
            log.warn((Object)("Could not convert value to a date instance: " + value));
            return null;
        }
        if (UICell.CellType.bool.name().equals(forceType)) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return Boolean.valueOf(value);
        }
        return value;
    }

    public static String cmp2String(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter oldResponseWriter = facesContext.getResponseWriter();
        String contentType = oldResponseWriter != null ? oldResponseWriter.getContentType() : DEFAULT_CONTENT_TYPE;
        String characterEncoding = oldResponseWriter != null ? oldResponseWriter.getCharacterEncoding() : DEFAULT_CHARACTER_ENCODING;
        StringWriter cacheingWriter = new StringWriter();
        Boolean scriptHiding = Boolean.FALSE;
        Boolean scriptInAttributes = Boolean.TRUE;
        WebConfiguration.DisableUnicodeEscaping escaping = WebConfiguration.DisableUnicodeEscaping.True;
        NXHtmlResponseWriter newResponseWriter = new NXHtmlResponseWriter(cacheingWriter, contentType, characterEncoding, scriptHiding, scriptInAttributes, escaping);
        facesContext.setResponseWriter((ResponseWriter)newResponseWriter);
        JSF.renderChild((FacesContext)facesContext, (UIComponent)component);
        if (oldResponseWriter != null) {
            facesContext.setResponseWriter(oldResponseWriter);
        }
        cacheingWriter.flush();
        cacheingWriter.close();
        return cacheingWriter.toString();
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression ve = this.getValueExpression("style");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getForceType() {
        if (this.forceType != null) {
            return this.forceType;
        }
        ValueExpression ve = this.getValueExpression("forceType");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setForceType(String forceType) {
        this.forceType = forceType;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.forceType = (String)values[1];
        this.style = (String)values[2];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.forceType, this.style};
    }
}

