/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.renderer;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.ImageRenderer;
import com.sun.faces.util.CollectionsUtils;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;

public class NXImageRenderer
extends ImageRenderer {
    protected static final Attribute[] ATTRIBUTES = (Attribute[])CollectionsUtils.ar((Object[])new Attribute[]{Attribute.attr((String)"alt"), Attribute.attr((String)"dir"), Attribute.attr((String)"lang"), Attribute.attr((String)"longdesc"), Attribute.attr((String)"onclick", (String[])new String[]{"click"}), Attribute.attr((String)"ondblclick", (String[])new String[]{"dblclick"}), Attribute.attr((String)"onkeydown", (String[])new String[]{"keydown"}), Attribute.attr((String)"onkeypress", (String[])new String[]{"keypress"}), Attribute.attr((String)"onkeyup", (String[])new String[]{"keyup"}), Attribute.attr((String)"onmousedown", (String[])new String[]{"mousedown"}), Attribute.attr((String)"onmousemove", (String[])new String[]{"mousemove"}), Attribute.attr((String)"onmouseout", (String[])new String[]{"mouseout"}), Attribute.attr((String)"onmouseover", (String[])new String[]{"mouseover"}), Attribute.attr((String)"onmouseup", (String[])new String[]{"mouseup"}), Attribute.attr((String)"role"), Attribute.attr((String)"style"), Attribute.attr((String)"title"), Attribute.attr((String)"usemap")});
    public static final String RENDERER_TYPE = "javax.faces.NXImage";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String src = NXImageRenderer.src(context, component);
        if (StringUtils.isBlank((CharSequence)src)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Do not render empty img tag with empty src value for component " + component.getId());
            }
        } else {
            Map attrs = component.getAttributes();
            String width = (String)attrs.get("width");
            String height = (String)attrs.get("height");
            String enableContainer = (String)attrs.get("enableContainer");
            boolean hasDivContainer = false;
            if (enableContainer != null && Boolean.parseBoolean(enableContainer)) {
                hasDivContainer = true;
            }
            if (hasDivContainer) {
                writer.startElement("div", component);
                writer.writeAttribute("class", (Object)"pictureContainer", "class");
                StringBuilder styleBuilder = new StringBuilder();
                if (!StringUtils.isEmpty((CharSequence)width)) {
                    styleBuilder.append("width:");
                    styleBuilder.append(width);
                    styleBuilder.append("px;");
                }
                if (!StringUtils.isEmpty((CharSequence)height)) {
                    styleBuilder.append("height:");
                    styleBuilder.append(height);
                    styleBuilder.append("px;");
                }
                if (styleBuilder.length() > 0) {
                    writer.writeAttribute("style", (Object)styleBuilder.toString(), "style");
                }
            }
            writer.startElement("img", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            writer.writeURIAttribute("src", (Object)src, "value");
            if (writer.getContentType().equals("application/xhtml+xml") && null == attrs.get("alt")) {
                writer.writeAttribute("alt", (Object)"", "alt");
            }
            RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])ATTRIBUTES);
            if (!hasDivContainer) {
                if (!StringUtils.isBlank((CharSequence)width)) {
                    writer.writeAttribute("width", (Object)width, "width");
                }
                if (!StringUtils.isBlank((CharSequence)height)) {
                    writer.writeAttribute("height", (Object)height, "height");
                }
            }
            RenderKitUtils.renderXHTMLStyleBooleanAttributes((ResponseWriter)writer, (UIComponent)component);
            String styleClass = (String)attrs.get("styleClass");
            if (!StringUtils.isBlank((CharSequence)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            writer.endElement("img");
            if (hasDivContainer) {
                writer.endElement("div");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    protected static String src(FacesContext context, UIComponent component) {
        String value = (String)((UIGraphic)component).getValue();
        if (value == null) {
            return "";
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }
}

