/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.jsf;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.ecm.web.resources.jsf.ScriptStyleBaseRenderer;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractResourceRenderer
extends ScriptStyleBaseRenderer {
    public static final String BUNDLE_ENDPOINT_PATH = "/wro/api/v1/resource/bundle/";
    @Deprecated
    public static final String ENDPOINT_PATH = "/wro/api/v1/resource/bundle/";
    public static final String PAGE_ENDPOINT_PATH = "/wro/api/v1/resource/page/";
    public static final String COMPONENTS_PATH = "/bower_components/";
    protected static final HtmlBasicRenderer.Param[] EMPTY_PARAMS = new HtmlBasicRenderer.Param[0];

    protected String resolveUrl(FacesContext context, UIComponent component) throws IOException {
        String url;
        Map attributes = component.getAttributes();
        String src = (String)attributes.get("src");
        if (src != null) {
            url = this.resolveResourceFromSource(context, component, src);
        } else {
            String name = (String)attributes.get("name");
            String library = (String)attributes.get("library");
            url = this.resolveResourceUrl(context, component, library, name);
        }
        return this.resolveUrlWithTimestamp(component, url);
    }

    protected String resolveUrlWithTimestamp(UIComponent component, String url) {
        Long timestamp;
        boolean doIncludeTimestamp = true;
        Object includeTimestamp = component.getAttributes().get("includeTimestamp");
        if (includeTimestamp instanceof String && !StringUtils.isBlank((CharSequence)((String)includeTimestamp))) {
            doIncludeTimestamp = Boolean.parseBoolean((String)includeTimestamp);
        }
        if (doIncludeTimestamp && (timestamp = ((WebResourceManager)Framework.getService(WebResourceManager.class)).getLastModified()) != null) {
            return URIUtils.addParametersToURIQuery((String)url, Collections.singletonMap("ts", String.valueOf(timestamp)));
        }
        return url;
    }

    protected String resolveResourceFromSource(FacesContext context, UIComponent component, String src) throws UnsupportedEncodingException {
        String value = context.getApplication().getViewHandler().getResourceURL(context, src);
        return this.getUrlWithParams(context, component, value);
    }

    protected Resource resolveNuxeoResource(FacesContext context, UIComponent component, String resource) throws UnsupportedEncodingException {
        WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
        return wrm.getResource(resource);
    }

    protected String resolveNuxeoResourcePath(Resource resource) {
        if (resource == null) {
            return null;
        }
        String name = resource.getName();
        if (ResourceType.css.matches(resource)) {
            String suffixed = name;
            if (!suffixed.endsWith(ResourceType.css.getSuffix())) {
                suffixed = suffixed + ResourceType.css.getSuffix();
            }
            return "/wro/api/v1/resource/bundle/" + suffixed;
        }
        if (ResourceType.js.matches(resource)) {
            String suffixed = name;
            if (!suffixed.endsWith(ResourceType.js.getSuffix())) {
                suffixed = suffixed + ResourceType.js.getSuffix();
            }
            return "/wro/api/v1/resource/bundle/" + suffixed;
        }
        if (ResourceType.html.matches(resource)) {
            return COMPONENTS_PATH + resource.getPath();
        }
        return resource.getURI();
    }

    protected String resolveNuxeoResourceUrl(FacesContext context, UIComponent component, String uri) throws UnsupportedEncodingException {
        String value = context.getApplication().getViewHandler().getResourceURL(context, uri);
        return this.getUrlWithParams(context, component, value);
    }

    protected String resolveResourceUrl(FacesContext context, UIComponent component, String library, String name) {
        String msg;
        Map contextMap = context.getAttributes();
        String key = name + library;
        if (null == name) {
            return null;
        }
        if (contextMap.containsKey(key)) {
            return null;
        }
        contextMap.put(key, Boolean.TRUE);
        int queryPos = name.indexOf("?");
        String query = null;
        if (queryPos > -1 && name.length() > queryPos) {
            query = name.substring(queryPos + 1);
            name = name.substring(0, queryPos);
        }
        javax.faces.application.Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        String resourceSrc = "RES_NOT_FOUND";
        WebConfiguration webConfig = WebConfiguration.getInstance();
        if (library == null && name != null && name.startsWith(webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.WebAppContractsDirectory))) {
            if (context.isProjectStage(ProjectStage.Development)) {
                msg = "Illegal path, direct contract references are not allowed: " + name;
                context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            }
            resource = null;
        }
        if (resource == null) {
            if (context.isProjectStage(ProjectStage.Development)) {
                msg = "Unable to find resource " + (library == null ? "" : library + ", ") + name;
                context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            }
        } else {
            resourceSrc = resource.getRequestPath();
            if (query != null) {
                resourceSrc = resourceSrc + (resourceSrc.indexOf("?") > -1 ? "&amp;" : "?") + query;
            }
            resourceSrc = context.getExternalContext().encodeResourceURL(resourceSrc);
        }
        return resourceSrc;
    }

    protected String getUrlWithParams(FacesContext context, UIComponent component, String src) throws UnsupportedEncodingException {
        HtmlBasicRenderer.Param[] paramList = this.getParamList(component);
        StringBuffer sb = new StringBuffer();
        sb.append(src);
        boolean paramWritten = false;
        int len = paramList.length;
        for (int i = 0; i < len; ++i) {
            String pn = paramList[i].name;
            if (pn == null || pn.length() == 0) continue;
            String pv = paramList[i].value;
            sb.append(paramWritten ? (char)'&' : '?');
            sb.append(URLEncoder.encode(pn, "UTF-8"));
            sb.append('=');
            if (pv != null && pv.length() != 0) {
                sb.append(URLEncoder.encode(pv, "UTF-8"));
            }
            paramWritten = true;
        }
        return context.getExternalContext().encodeResourceURL(sb.toString());
    }

    protected HtmlBasicRenderer.Param[] getParamList(UIComponent command) {
        String flavor = (String)command.getAttributes().get("flavor");
        if (StringUtils.isNotBlank((CharSequence)flavor) || command.getChildCount() > 0) {
            ArrayList<HtmlBasicRenderer.Param> parameterList = new ArrayList<HtmlBasicRenderer.Param>();
            if (StringUtils.isNotBlank((CharSequence)flavor)) {
                HtmlBasicRenderer.Param param = new HtmlBasicRenderer.Param("flavor", flavor);
                parameterList.add(param);
            }
            for (UIComponent kid : command.getChildren()) {
                UIParameter uiParam;
                if (!(kid instanceof UIParameter) || (uiParam = (UIParameter)kid).isDisable()) continue;
                Object value = uiParam.getValue();
                HtmlBasicRenderer.Param param = new HtmlBasicRenderer.Param(uiParam.getName(), value == null ? null : value.toString());
                parameterList.add(param);
            }
            return parameterList.toArray(new HtmlBasicRenderer.Param[parameterList.size()]);
        }
        return EMPTY_PARAMS;
    }
}

