/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.application.DecodeRepresentation;
import java.util.Iterator;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.Encoding;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;

public class Decoder
extends Filter {
    private boolean decodeRequest;
    private boolean decodeResponse;

    public Decoder(Context context) {
        this(context, true, false);
    }

    public Decoder(Context context, boolean decodeRequest, boolean decodeResponse) {
        super(context);
        this.decodeRequest = decodeRequest;
        this.decodeResponse = decodeResponse;
    }

    public void beforeHandle(Request request, Response response) {
        if (this.isDecodeRequest() && this.canDecode(request.getEntity())) {
            request.setEntity(this.decode(request.getEntity()));
        }
    }

    public void afterHandle(Request request, Response response) {
        if (this.isDecodeResponse() && this.canDecode(response.getEntity())) {
            response.setEntity(this.decode(response.getEntity()));
        }
    }

    public boolean canDecode(Representation representation) {
        boolean result;
        boolean bl = result = representation != null && !representation.getEncodings().isEmpty();
        if (result) {
            boolean found = false;
            Iterator iter = representation.getEncodings().iterator();
            while (!found && iter.hasNext()) {
                found = !((Encoding)iter.next()).equals((Object)Encoding.IDENTITY);
            }
            result = found;
        }
        return result;
    }

    public Representation decode(Representation representation) {
        Object result = representation;
        boolean supported = true;
        boolean identityEncodings = true;
        Iterator iter = representation.getEncodings().iterator();
        while (supported && iter.hasNext()) {
            Encoding encoding = (Encoding)iter.next();
            supported = DecodeRepresentation.getSupportedEncodings().contains(encoding);
            identityEncodings &= encoding.equals((Object)Encoding.IDENTITY);
        }
        if (supported && !identityEncodings) {
            result = new DecodeRepresentation(representation);
        }
        return result;
    }

    public boolean isDecodeRequest() {
        return this.decodeRequest;
    }

    public void setDecodeRequest(boolean decodeRequest) {
        this.decodeRequest = decodeRequest;
    }

    public boolean isDecodeResponse() {
        return this.decodeResponse;
    }

    public void setDecodeResponse(boolean decodeResponse) {
        this.decodeResponse = decodeResponse;
    }
}

