/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;
import yarfraw.utils.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextInput
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private String _title;
    private String _description;
    private String _name;
    private String _link;

    public TextInput() {
    }

    public TextInput(String title, String description, String name, String link) {
        this._title = title;
        this._description = description;
        this._name = name;
        this.setLink(link);
    }

    public String getTitle() {
        return this._title;
    }

    public TextInput setTitle(String title) {
        this._title = title;
        return this;
    }

    public String getDescription() {
        return this._description;
    }

    public TextInput setDescription(String description) {
        this._description = description;
        return this;
    }

    public String getName() {
        return this._name;
    }

    public TextInput setName(String name) {
        this._name = name;
        return this;
    }

    public String getLink() {
        return this._link;
    }

    public TextInput setLink(String link) {
        this._link = link;
        return this;
    }

    public TextInput setResource(String resource) {
        this._resource = resource;
        return this;
    }

    public TextInput setAbout(String about) {
        this._about = about;
        return this;
    }

    public TextInput setOtherAttributes(Map<QName, String> otherAttributes) {
        this._otherAttributes = otherAttributes;
        return this;
    }

    public TextInput addOtherAttributes(QName namespace, String attribute) {
        if (this._otherAttributes == null) {
            this._otherAttributes = new HashMap();
        }
        this._otherAttributes.put(namespace, attribute);
        return this;
    }

    public TextInput setOtherElements(List<Element> otherElements) {
        this._otherElements = otherElements;
        return this;
    }

    public TextInput addOtherElement(Element element) {
        if (this._otherElements == null) {
            this._otherElements = new ArrayList();
        }
        this._otherElements.add(element);
        return this;
    }

    public TextInput addOtherElement(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        return this.addOtherElement(XMLUtils.parseXml(xmlString, false, false).getDocumentElement());
    }

    @Override
    public void validate(FeedFormat format) throws ValidationException {
        if (format == FeedFormat.ATOM10) {
            return;
        }
        if (format == FeedFormat.RSS20) {
            ValidationUtils.validateNotNull("Image: All required fields in the Image object should be not null", this._title, this._link, this._description, this._name);
            ValidationUtils.validateUri("link is not a valid URI", this._link);
        }
        if (format == FeedFormat.RSS10) {
            ValidationUtils.validateNotNull("[Textinput] about is required", this.getAbout());
        }
    }
}

