/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.JavaScriptParameter;

public class UIActionParameter
extends UIParameter
implements ActionListener,
JavaScriptParameter {
    public static final String COMPONENT_TYPE = "org.ajax4jsf.components.UIActionParameter";
    private static String noEscapeAttr = "noEscape";
    private MethodExpression actionListener = null;
    private ValueExpression assignToBinding = null;
    private Converter converter = null;
    private Boolean noEscape = null;

    public void setAssignToBinding(ValueExpression propertyBinding) {
        this.assignToBinding = propertyBinding;
    }

    public ValueExpression getAssignToBinding() {
        return this.assignToBinding;
    }

    public MethodExpression getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(MethodExpression actionListener) {
        this.actionListener = actionListener;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setNoEscape(boolean noEscape) {
        this.noEscape = noEscape;
    }

    public boolean isNoEscape() {
        return this.isValueOrBinding(this.noEscape, noEscapeAttr);
    }

    public String getName() {
        String name = super.getName();
        if (null == name) {
            name = this.getClientId(FacesContext.getCurrentInstance());
        }
        return name;
    }

    public Object getValue() {
        Object value = super.getValue();
        if (null != value) {
            Class<?> type = value.getClass();
            FacesContext context = this.getFacesContext();
            Converter converter = this.createConverter(context, type);
            if (null != converter) {
                value = converter.getAsString(context, (UIComponent)this, value);
            }
        }
        return value;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = this.getFacesContext();
        ELContext elContext = context.getELContext();
        ValueExpression updateBinding = this.getAssignToBinding();
        if (updateBinding != null && !updateBinding.isReadOnly(elContext)) {
            MethodExpression listener;
            Class type;
            Converter converter;
            Object requestValue = context.getExternalContext().getRequestParameterMap().get(this.getName());
            if (requestValue != null && requestValue instanceof String && null != (converter = this.createConverter(context, type = updateBinding.getType(elContext)))) {
                requestValue = converter.getAsObject(context, (UIComponent)this, (String)requestValue);
            }
            if (null != requestValue) {
                updateBinding.setValue(elContext, requestValue);
            }
            if ((listener = this.getActionListener()) != null) {
                listener.invoke(elContext, new Object[]{actionEvent});
            }
        }
    }

    private Converter createConverter(FacesContext context, Class<?> type) throws FacesException {
        Converter converter = this.getConverter();
        if (converter == null && type != null && !type.equals(String.class) && !type.equals(Object.class)) {
            try {
                converter = context.getApplication().createConverter(type);
            }
            catch (Exception e) {
                throw new FacesException(Messages.getMessage((String)"NO_CONVERTER_REGISTERED", (Object)type.getName()), (Throwable)e);
            }
        }
        return converter;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.assignToBinding = (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[1]);
        this.noEscape = (Boolean)values[2];
        this.converter = (Converter)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this.actionListener = (MethodExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[4]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.assignToBinding), this.noEscape, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.converter), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.actionListener)};
        return values;
    }

    private boolean isValueOrBinding(Boolean field, String name) {
        if (null != field) {
            return field;
        }
        ValueExpression vb = this.getValueExpression(name);
        if (null != vb) {
            FacesContext context = this.getFacesContext();
            ELContext elContext = context.getELContext();
            return (Boolean)vb.getValue(elContext);
        }
        return false;
    }
}

