/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.io.DocumentPipe;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.restlet.data.MediaType;
import org.restlet.resource.OutputRepresentation;

public abstract class ExportRepresentation
extends OutputRepresentation {
    private static final Log log = LogFactory.getLog(ExportRepresentation.class);
    protected final String repositoryName;
    protected final String rootId;
    protected final boolean isUnrestricted;

    protected ExportRepresentation(MediaType mediaType, DocumentModel root) {
        this(mediaType, root, false);
    }

    protected ExportRepresentation(MediaType mediaType, DocumentModel root, boolean unrestricted) {
        super(mediaType);
        this.repositoryName = root.getRepositoryName();
        this.rootId = root.getId();
        this.isUnrestricted = unrestricted;
    }

    protected abstract DocumentPipe makePipe();

    protected abstract DocumentReader makeDocumentReader(CoreSession var1, DocumentModel var2);

    protected abstract DocumentWriter makeDocumentWriter(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws IOException {
        try (CloseableCoreSession session = this.isUnrestricted ? CoreInstance.openCoreSessionSystem((String)this.repositoryName) : CoreInstance.openCoreSession((String)this.repositoryName);){
            DocumentReader documentReader = null;
            DocumentWriter documentWriter = null;
            try {
                DocumentModel root = session.getDocument((DocumentRef)new IdRef(this.rootId));
                documentReader = this.makeDocumentReader((CoreSession)session, root);
                documentWriter = this.makeDocumentWriter(outputStream);
                DocumentPipe pipe = this.makePipe();
                pipe.setReader(documentReader);
                pipe.setWriter(documentWriter);
                pipe.run();
            }
            finally {
                if (documentReader != null) {
                    documentReader.close();
                }
                if (documentWriter != null) {
                    documentWriter.close();
                }
            }
        }
    }
}

