/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;

public class ThreeDRenderView {
    public static final String TITLE = "title";
    public static final String CONTENT = "content";
    public static final String THUMBNAIL = "thumbnail";
    public static final String AZIMUTH = "azimuth";
    public static final String ZENITH = "zenith";
    protected final Blob content;
    protected final Blob thumbnail;
    protected final String title;
    protected final int azimuth;
    protected final int zenith;

    public ThreeDRenderView(String title, Blob content, Blob thumbnail, int azimuth, int zenith) {
        this.title = title;
        this.content = content;
        this.thumbnail = thumbnail;
        this.azimuth = azimuth;
        this.zenith = zenith;
    }

    public ThreeDRenderView(Map<String, Serializable> map) {
        this.title = (String)((Object)map.get(TITLE));
        this.content = (Blob)map.get(CONTENT);
        this.thumbnail = (Blob)map.get(THUMBNAIL);
        Long azimuthLong = (Long)map.get(AZIMUTH);
        this.azimuth = azimuthLong != null ? azimuthLong.intValue() : 0;
        Long zenithLong = (Long)map.get(ZENITH);
        this.zenith = zenithLong != null ? zenithLong.intValue() : 0;
    }

    public Blob getContent() {
        return this.content;
    }

    public Blob getThumbnail() {
        return this.thumbnail;
    }

    public String getTitle() {
        return this.title;
    }

    public int getAzimuth() {
        return this.azimuth;
    }

    public int getZenith() {
        return this.zenith;
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(TITLE, (Serializable)((Object)this.title));
        map.put(CONTENT, (Serializable)this.content);
        map.put(THUMBNAIL, (Serializable)this.thumbnail);
        map.put(AZIMUTH, Integer.valueOf(this.azimuth));
        map.put(ZENITH, Integer.valueOf(this.zenith));
        return map;
    }
}

