/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache.lru;

import java.util.Date;

public final class CacheEntry
implements Comparable<CacheEntry> {
    private Date expired;
    private Object key;
    private Object value;

    public CacheEntry(Object key, Object value, Date expired) {
        this.key = key;
        this.value = value;
        this.expired = expired == null ? null : (Date)expired.clone();
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isExpired() {
        return this.expired != null && System.currentTimeMillis() >= this.expired.getTime();
    }

    public Date getExpired() {
        return this.expired == null ? null : (Date)this.expired.clone();
    }

    @Override
    public int compareTo(CacheEntry o) {
        int result = this.expired.compareTo(o.expired);
        if (result == 0) {
            result = this.key.toString().compareTo(o.key.toString());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheEntry other = (CacheEntry)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return "<CacheEntry> " + (this.expired == null ? this.key.toString() : this.key + ": " + this.expired);
    }
}

