/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.handler.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.activation.MimetypesFileTypeMap;
import javax.faces.application.Resource;
import org.richfaces.resource.optimizer.resource.handler.impl.AbstractResourceHandler;
import org.richfaces.resource.optimizer.resource.handler.impl.VFSResource;
import org.richfaces.resource.optimizer.resource.util.ResourceUtil;
import org.richfaces.resource.optimizer.vfs.VirtualFile;

public class StaticResourceHandler
extends AbstractResourceHandler {
    private Collection<VirtualFile> roots;

    public StaticResourceHandler(Collection<VirtualFile> roots) {
        this.roots = roots;
    }

    private Collection<VirtualFile> findLibraries(String libraryName) {
        LinkedList libraryDirs = Lists.newLinkedList();
        for (VirtualFile file : this.roots) {
            VirtualFile libraryDir;
            VirtualFile child = file.getChild(libraryName);
            if (child == null || (libraryDir = ResourceUtil.getLatestVersion(child, true)) == null) continue;
            libraryDirs.add(libraryDir);
        }
        return libraryDirs;
    }

    private VirtualFile findResource(Collection<VirtualFile> libraryDirs, String resourceName) {
        for (VirtualFile libraryDir : libraryDirs) {
            VirtualFile resource;
            VirtualFile child = libraryDir.getChild(resourceName);
            if (child == null || (resource = ResourceUtil.getLatestVersion(child, false)) == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Collection<Object> libraryDirs = Collections.emptyList();
        libraryDirs = !Strings.isNullOrEmpty((String)libraryName) ? this.findLibraries(libraryName) : this.roots;
        VirtualFile resource = this.findResource(libraryDirs, resourceName);
        if (resource != null) {
            VFSResource result = new VFSResource(resource, resource.getRelativePath());
            result.setResourceName(resourceName);
            result.setLibraryName(libraryName);
            if (Strings.isNullOrEmpty((String)contentType)) {
                result.setContentType(MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(resourceName));
            } else {
                result.setContentType(contentType);
            }
            return result;
        }
        return null;
    }
}

