/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.jsf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayout;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayoutImpl;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.ReferencePageProviderDescriptor;

@XObject(value="contentView")
public class ContentViewDescriptor {
    @XNode(value="@name")
    String name;
    @XNode(value="@enabled")
    boolean enabled = true;
    @XNode(value="title")
    String title;
    @XNode(value="translateTitle")
    Boolean translateTitle;
    @XNode(value="emptySentence")
    String emptySentence;
    @XNode(value="waitForExecutionSentence")
    String waitForExecutionSentence;
    @XNode(value="translateEmptySentence")
    Boolean translateEmptySentence;
    @XNode(value="iconPath")
    String iconPath;
    @XNode(value="coreQueryPageProvider")
    CoreQueryPageProviderDescriptor coreQueryPageProvider;
    @XNode(value="genericPageProvider")
    GenericPageProviderDescriptor genericPageProvider;
    @XNode(value="pageProvider")
    ReferencePageProviderDescriptor referencePageProvider;
    @XNode(value="selectionList")
    String selectionList;
    @XNode(value="pagination")
    String pagination;
    @XNodeList(value="actions@category", type=ArrayList.class, componentType=String.class)
    List<String> actionCategories;
    @XNode(value="searchDocument")
    String searchDocument;
    @XNode(value="searchLayout")
    ContentViewLayoutImpl searchLayout;
    @XNode(value="resultLayouts@append")
    Boolean appendResultLayouts;
    @XNodeList(value="resultLayouts/layout", type=ArrayList.class, componentType=ContentViewLayoutImpl.class)
    List<ContentViewLayout> resultLayouts;
    @XNode(value="resultColumns")
    String resultColumns;
    @XNode(value="resultLayout")
    String resultLayout;
    @XNodeList(value="flags/flag", type=ArrayList.class, componentType=String.class)
    List<String> flags;
    @XNode(value="cacheKey")
    String cacheKey;
    @XNode(value="cacheSize")
    Integer cacheSize;
    @XNode(value="useGlobalPageSize")
    Boolean useGlobalPageSize;
    @XNode(value="showTitle")
    Boolean showTitle;
    @XNode(value="showPageSizeSelector")
    Boolean showPageSizeSelector;
    @XNode(value="showRefreshCommand")
    Boolean showRefreshCommand;
    @XNode(value="showFilterForm")
    Boolean showFilterForm;
    @XNode(value="waitForExecution")
    Boolean waitForExecution;
    @XNodeList(value="refresh/event", type=ArrayList.class, componentType=String.class)
    List<String> refreshEventNames;
    @XNodeList(value="reset/event", type=ArrayList.class, componentType=String.class)
    List<String> resetEventNames;
    protected String pageProviderName;
    protected Map<String, String> pageProviderProperties;

    public String getName() {
        return this.name;
    }

    public CoreQueryPageProviderDescriptor getCoreQueryPageProvider() {
        return this.coreQueryPageProvider;
    }

    public GenericPageProviderDescriptor getGenericPageProvider() {
        return this.genericPageProvider;
    }

    public ReferencePageProviderDescriptor getReferencePageProvider() {
        return this.referencePageProvider;
    }

    public String getSelectionListName() {
        return this.selectionList;
    }

    public String getPagination() {
        return this.pagination;
    }

    public List<String> getActionCategories() {
        return this.actionCategories;
    }

    public ContentViewLayoutImpl getSearchLayout() {
        return this.searchLayout;
    }

    public Boolean getAppendResultLayouts() {
        return this.appendResultLayouts;
    }

    public List<ContentViewLayout> getResultLayouts() {
        return this.resultLayouts;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public List<String> getRefreshEventNames() {
        return this.refreshEventNames;
    }

    public List<String> getResetEventNames() {
        return this.resetEventNames;
    }

    public Boolean getUseGlobalPageSize() {
        return this.useGlobalPageSize;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getTranslateTitle() {
        return this.translateTitle;
    }

    public String getSearchDocumentBinding() {
        return this.searchDocument;
    }

    public String getResultColumnsBinding() {
        return this.resultColumns;
    }

    public String getResultLayoutBinding() {
        return this.resultLayout;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getShowTitle() {
        return this.showTitle;
    }

    public Boolean getShowPageSizeSelector() {
        if (this.showPageSizeSelector == null) {
            return Boolean.TRUE;
        }
        return this.showPageSizeSelector;
    }

    public Boolean getShowRefreshCommand() {
        if (this.showRefreshCommand == null) {
            return Boolean.TRUE;
        }
        return this.showRefreshCommand;
    }

    public Boolean getShowFilterForm() {
        return this.showFilterForm;
    }

    public String getEmptySentence() {
        return this.emptySentence;
    }

    public String getWaitForExecutionSentence() {
        return this.waitForExecutionSentence;
    }

    public Boolean getTranslateEmptySentence() {
        return this.translateEmptySentence;
    }

    public String getPageProviderName() {
        if (this.pageProviderName == null) {
            this.pageProviderName = this.referencePageProvider != null && this.referencePageProvider.isEnabled() ? this.referencePageProvider.getName() : (this.coreQueryPageProvider != null && this.coreQueryPageProvider.isEnabled() && this.coreQueryPageProvider.getName() != null ? this.coreQueryPageProvider.getName() : (this.genericPageProvider != null && this.genericPageProvider.isEnabled() && this.genericPageProvider.getName() != null ? this.genericPageProvider.getName() : this.getName()));
        }
        return this.pageProviderName;
    }

    public Map<String, String> getPageProviderProperties() {
        if (this.pageProviderProperties == null) {
            if (this.referencePageProvider != null && this.referencePageProvider.isEnabled()) {
                this.pageProviderProperties = this.referencePageProvider.getProperties();
            } else if (this.coreQueryPageProvider != null && this.coreQueryPageProvider.isEnabled()) {
                this.pageProviderProperties = this.coreQueryPageProvider.getProperties();
            } else if (this.genericPageProvider != null && this.genericPageProvider.isEnabled()) {
                this.pageProviderProperties = this.genericPageProvider.getProperties();
            }
        }
        return this.pageProviderProperties;
    }

    public Boolean getWaitForExecution() {
        return this.waitForExecution;
    }

    public void merge(ContentViewDescriptor newDesc) {
        Boolean waitForFilter;
        String resultLayout;
        String resultCols;
        String searchDocument;
        Boolean showFilterForm;
        Boolean showRefreshCommand;
        Boolean showPageSizeSelector;
        Boolean showTitle;
        Boolean useGlobalPageSize;
        String selectionList;
        List<String> flags;
        List<ContentViewLayout> resultLayouts;
        ContentViewLayoutImpl searchLayout;
        List<String> events;
        String pagination;
        ReferencePageProviderDescriptor refDesc;
        GenericPageProviderDescriptor genDesc;
        CoreQueryPageProviderDescriptor coreDesc;
        Integer cacheSize;
        String cacheKey;
        List<String> actions;
        String iconPath;
        Boolean translateEmptySentence;
        String waitForExecutionSentence;
        String emptySentence;
        Boolean translateTitle;
        this.setEnabled(newDesc.isEnabled());
        String title = newDesc.getTitle();
        if (title != null) {
            this.title = title;
        }
        if ((translateTitle = newDesc.getTranslateTitle()) != null) {
            this.translateTitle = translateTitle;
        }
        if ((emptySentence = newDesc.getEmptySentence()) != null) {
            this.emptySentence = emptySentence;
        }
        if ((waitForExecutionSentence = newDesc.getWaitForExecutionSentence()) != null) {
            this.waitForExecutionSentence = waitForExecutionSentence;
        }
        if ((translateEmptySentence = newDesc.getTranslateEmptySentence()) != null) {
            this.translateEmptySentence = translateEmptySentence;
        }
        if ((iconPath = newDesc.getIconPath()) != null) {
            this.iconPath = iconPath;
        }
        if ((actions = newDesc.getActionCategories()) != null && !actions.isEmpty()) {
            this.actionCategories = actions;
        }
        if ((cacheKey = newDesc.getCacheKey()) != null) {
            this.cacheKey = cacheKey;
        }
        if ((cacheSize = newDesc.getCacheSize()) != null) {
            this.cacheSize = cacheSize;
        }
        if ((coreDesc = newDesc.getCoreQueryPageProvider()) != null && coreDesc.isEnabled()) {
            this.coreQueryPageProvider = coreDesc;
            this.genericPageProvider = null;
            this.referencePageProvider = null;
        }
        if ((genDesc = newDesc.getGenericPageProvider()) != null && genDesc.isEnabled()) {
            this.genericPageProvider = genDesc;
            this.coreQueryPageProvider = null;
            this.referencePageProvider = null;
        }
        if ((refDesc = newDesc.getReferencePageProvider()) != null && refDesc.isEnabled()) {
            this.referencePageProvider = refDesc;
            this.coreQueryPageProvider = null;
            this.genericPageProvider = null;
        }
        if ((pagination = newDesc.getPagination()) != null) {
            this.pagination = pagination;
        }
        if ((events = newDesc.getRefreshEventNames()) != null && !events.isEmpty()) {
            this.refreshEventNames = events;
        }
        if ((events = newDesc.getResetEventNames()) != null && !events.isEmpty()) {
            this.resetEventNames = events;
        }
        if ((searchLayout = newDesc.getSearchLayout()) != null) {
            this.searchLayout = searchLayout;
        }
        if ((resultLayouts = newDesc.getResultLayouts()) != null) {
            Boolean appendResultLayout = newDesc.getAppendResultLayouts();
            if (Boolean.TRUE.equals(appendResultLayout) || resultLayouts.isEmpty()) {
                ArrayList<ContentViewLayout> allLayouts = new ArrayList<ContentViewLayout>();
                if (this.resultLayouts != null) {
                    allLayouts.addAll(this.resultLayouts);
                }
                allLayouts.addAll(resultLayouts);
                this.resultLayouts = allLayouts;
            } else {
                this.resultLayouts = resultLayouts;
            }
        }
        if ((flags = newDesc.getFlags()) != null && !flags.isEmpty()) {
            this.flags = flags;
        }
        if ((selectionList = newDesc.getSelectionListName()) != null) {
            this.selectionList = selectionList;
        }
        if ((useGlobalPageSize = newDesc.getUseGlobalPageSize()) != null) {
            this.useGlobalPageSize = useGlobalPageSize;
        }
        if ((showTitle = newDesc.getShowTitle()) != null) {
            this.showTitle = showTitle;
        }
        if ((showPageSizeSelector = newDesc.showPageSizeSelector) != null) {
            this.showPageSizeSelector = showPageSizeSelector;
        }
        if ((showRefreshCommand = newDesc.showRefreshCommand) != null) {
            this.showRefreshCommand = showRefreshCommand;
        }
        if ((showFilterForm = newDesc.getShowFilterForm()) != null) {
            this.showFilterForm = showFilterForm;
        }
        if ((searchDocument = newDesc.getSearchDocumentBinding()) != null) {
            this.searchDocument = searchDocument;
        }
        if ((resultCols = newDesc.getResultColumnsBinding()) != null) {
            this.resultColumns = resultCols;
        }
        if ((resultLayout = newDesc.getResultLayoutBinding()) != null) {
            this.resultLayout = resultLayout;
        }
        if ((waitForFilter = newDesc.getWaitForExecution()) != null) {
            this.waitForExecution = waitForFilter;
        }
    }

    public ContentViewDescriptor clone() {
        List<String> reset;
        ReferencePageProviderDescriptor rpp;
        GenericPageProviderDescriptor gpp;
        ContentViewDescriptor clone = new ContentViewDescriptor();
        clone.name = this.getName();
        clone.enabled = this.isEnabled();
        clone.title = this.getTitle();
        clone.translateTitle = this.getTranslateTitle();
        clone.emptySentence = this.getEmptySentence();
        clone.waitForExecutionSentence = this.getWaitForExecutionSentence();
        clone.translateEmptySentence = this.getTranslateEmptySentence();
        clone.iconPath = this.getIconPath();
        CoreQueryPageProviderDescriptor cpp = this.getCoreQueryPageProvider();
        if (cpp != null) {
            clone.coreQueryPageProvider = cpp.clone();
        }
        if ((gpp = this.getGenericPageProvider()) != null) {
            clone.genericPageProvider = gpp.clone();
        }
        if ((rpp = this.getReferencePageProvider()) != null) {
            clone.referencePageProvider = rpp.clone();
        }
        clone.selectionList = this.getSelectionListName();
        clone.pagination = this.getPagination();
        List<String> actionCats = this.getActionCategories();
        if (actionCats != null) {
            clone.actionCategories = new ArrayList<String>();
            clone.actionCategories.addAll(actionCats);
        }
        clone.searchDocument = this.getSearchDocumentBinding();
        ContentViewLayoutImpl searchLayout = this.getSearchLayout();
        if (searchLayout != null) {
            clone.searchLayout = searchLayout.clone();
        }
        clone.appendResultLayouts = this.getAppendResultLayouts();
        List<ContentViewLayout> resultLayouts = this.getResultLayouts();
        if (resultLayouts != null) {
            clone.resultLayouts = new ArrayList<ContentViewLayout>();
            for (ContentViewLayout item : resultLayouts) {
                clone.resultLayouts.add(item.clone());
            }
        }
        clone.resultColumns = this.getResultColumnsBinding();
        clone.resultLayout = this.getResultLayoutBinding();
        List<String> flags = this.getFlags();
        if (flags != null) {
            clone.flags = new ArrayList<String>();
            clone.flags.addAll(flags);
        }
        clone.cacheKey = this.getCacheKey();
        clone.cacheSize = this.getCacheSize();
        clone.useGlobalPageSize = this.getUseGlobalPageSize();
        clone.showTitle = this.getShowTitle();
        clone.showPageSizeSelector = this.getShowPageSizeSelector();
        clone.showRefreshCommand = this.getShowRefreshCommand();
        clone.showFilterForm = this.getShowFilterForm();
        List<String> refresh = this.getRefreshEventNames();
        if (refresh != null) {
            clone.refreshEventNames = new ArrayList<String>();
            clone.refreshEventNames.addAll(refresh);
        }
        if ((reset = this.getResetEventNames()) != null) {
            clone.resetEventNames = new ArrayList<String>();
            clone.resetEventNames.addAll(reset);
        }
        clone.waitForExecution = this.getWaitForExecution();
        return clone;
    }
}

