/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.Request;
import org.restlet.data.Response;

@Name(value="uploadFileRestlet")
@Scope(value=ScopeType.EVENT)
public class UploadFileRestlet
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    public static final String LIVED_AUTOVERSIONING_PROP = "org.nuxeo.ecm.platform.liveedit.autoversioning";
    public static final String POLICY_MINOR_INCR = "minor";
    private static final long serialVersionUID = -6167207806181917456L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected CoreSession documentManager;

    public void handle(Request req, Response res) {
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String filename = (String)req.getAttributes().get("filename");
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            UploadFileRestlet.handleError(res, e);
            return;
        }
        if (repo == null || repo.equals("*")) {
            UploadFileRestlet.handleError(res, "you must specify a repository");
            return;
        }
        DocumentModel dm = null;
        try {
            this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            if (docid != null) {
                dm = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
            }
        }
        catch (NuxeoException e) {
            UploadFileRestlet.handleError(res, (Exception)((Object)e));
            return;
        }
        try {
            String blobPropertyName = UploadFileRestlet.getQueryParamValue(req, "blobPropertyName", null);
            if (blobPropertyName == null) {
                String schemaName = UploadFileRestlet.getQueryParamValue(req, "schema", "file");
                String blobFieldName = UploadFileRestlet.getQueryParamValue(req, "blobField", "content");
                blobPropertyName = schemaName + ":" + blobFieldName;
            }
            InputStream is = req.getEntity().getStream();
            this.saveFileToDocument(filename, dm, blobPropertyName, is);
        }
        catch (IOException | NuxeoException e) {
            UploadFileRestlet.handleError(res, (Exception)e);
        }
    }

    protected CoreSession getDocumentManager() {
        return this.documentManager;
    }

    @Deprecated
    protected void saveFileToDocument(String filename, DocumentModel dm, String blobPropertyName, String filenamePropertyName, InputStream is) throws IOException, PropertyException {
        this.saveFileToDocument(filename, dm, blobPropertyName, is);
    }

    protected void saveFileToDocument(String filename, DocumentModel dm, String blobPropertyName, InputStream is) throws IOException, PropertyException {
        Blob blob = Blobs.createBlob((InputStream)is);
        blob.setFilename(filename);
        dm.setPropertyValue(blobPropertyName, (Serializable)blob);
        this.getDocumentManager().saveDocument(dm);
        String versioningPolicy = Framework.getProperty((String)LIVED_AUTOVERSIONING_PROP);
        if (this.doAutoMinorIncrement(versioningPolicy, dm) && dm.isCheckedOut()) {
            dm.checkIn(VersioningOption.MINOR, "Live edit (UploadFileRestlet) autoversioning");
        }
        this.getDocumentManager().save();
    }

    protected boolean doAutoMinorIncrement(String policy, DocumentModel doc) {
        return POLICY_MINOR_INCR.equals(policy);
    }
}

