/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.adapter;

import java.io.File;
import java.io.IOException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.platform.threed.ThreeDDocument;
import org.nuxeo.ecm.platform.threed.ThreeDRenderView;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class ThumbnailThreeDFactory
implements ThumbnailFactory {
    public Blob getThumbnail(DocumentModel documentModel, CoreSession coreSession) {
        if (!documentModel.hasFacet("ThreeD")) {
            throw new NuxeoException("Document is not 3D");
        }
        ThreeDDocument threeDDoc = (ThreeDDocument)documentModel.getAdapter(ThreeDDocument.class);
        Blob thumbnailBlob = null;
        if (!threeDDoc.getRenderViews().isEmpty()) {
            thumbnailBlob = ((ThreeDRenderView)threeDDoc.getRenderViews().iterator().next()).getContent();
        }
        if (thumbnailBlob == null) {
            TypeInfo docType = (TypeInfo)documentModel.getAdapter(TypeInfo.class);
            try {
                return Blobs.createBlob((File)FileUtils.getResourceFileFromContext((String)("nuxeo.war" + File.separator + docType.getBigIcon())));
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return thumbnailBlob;
    }

    public Blob computeThumbnail(DocumentModel documentModel, CoreSession coreSession) {
        return null;
    }
}

