/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private String _value;
    private String _uri;
    private String _version;

    public Generator(String generatorValue) {
        this._value = generatorValue;
    }

    public String getValue() {
        return this._value;
    }

    public Generator setValue(String value) {
        this._value = value;
        return this;
    }

    public String getUri() {
        return this._uri;
    }

    public Generator setUri(String uri) {
        this._uri = uri;
        return this;
    }

    public String getVersion() {
        return this._version;
    }

    public Generator setVersion(String version) {
        this._version = version;
        return this;
    }

    public Generator setOtherAttributes(Map<QName, String> otherAttributes) {
        this._otherAttributes = otherAttributes;
        return this;
    }

    public Generator addOtherAttributes(QName namespace, String attribute) {
        if (this._otherAttributes == null) {
            this._otherAttributes = new HashMap();
        }
        this._otherAttributes.put(namespace, attribute);
        return this;
    }

    public Generator setBase(String base) {
        this._base = base;
        return this;
    }

    public Generator setLang(String lang) {
        this._lang = lang;
        return this;
    }

    public Generator setLang(Locale lang) {
        this._lang = lang.getLanguage();
        return this;
    }

    @Override
    public void validate(FeedFormat format) throws ValidationException {
        if (format == FeedFormat.RSS10) {
            return;
        }
        ValidationUtils.validateNotNull("[Generator] Value should not be null", this._value);
        ValidationUtils.validateUri("[Generator] uri should be an valid uri", this._uri);
    }
}

