/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelect;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItemComparator;
import org.nuxeo.ecm.platform.ui.web.directory.Selection;
import org.nuxeo.ecm.platform.ui.web.directory.VocabularyEntryList;

public class ChainSelectListboxComponent
extends UIInput
implements ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "nxdirectory.chainSelectListbox";
    public static final String COMPONENT_FAMILY = "nxdirectory.chainSelectListbox";
    private static final Log log = LogFactory.getLog(ChainSelectListboxComponent.class);
    public boolean ajaxUpdated = false;
    private String directoryName;
    private VocabularyEntryList directoryValues;
    private Boolean displayIdAndLabel = false;
    private Boolean displayObsoleteEntries = false;
    private String onchange;
    private int index;
    private String displayIdAndLabelSeparator = " ";
    private String cssStyle;
    private String cssStyleClass;
    private String size;
    private Boolean localize = false;
    private String displayValueOnlySeparator;
    private String ordering;
    private String display;
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("blur", "change", "valueChange", "click", "dblclick", "focus", "keydown", "keypress", "keyup", "mousedown", "mousemove", "mouseout", "mouseover", "mouseup", "select"));

    public ChainSelectListboxComponent() {
        this.setRendererType("nxdirectory.chainSelectListbox");
    }

    public String getFamily() {
        return "nxdirectory.chainSelectListbox";
    }

    public boolean isMultiSelect() {
        ChainSelect chain = this.getChain();
        if (chain != null) {
            boolean isLastSelect = this.getIndex() == chain.getSize() - 1;
            boolean isChainMultiSelect = chain.getBooleanProperty("multiSelect", false);
            return isLastSelect && isChainMultiSelect;
        }
        return false;
    }

    public String getDisplayIdAndLabelSeparator() {
        return this.displayIdAndLabelSeparator;
    }

    public void setDisplayIdAndLabelSeparator(String displayIdAndLabelSeparator) {
        this.displayIdAndLabelSeparator = displayIdAndLabelSeparator;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.index = (Integer)values[1];
        this.displayIdAndLabel = (Boolean)values[2];
        this.displayIdAndLabelSeparator = (String)values[3];
        this.displayObsoleteEntries = (Boolean)values[4];
        this.ajaxUpdated = (Boolean)values[5];
        this.directoryName = (String)values[6];
        this.localize = (Boolean)values[7];
        this.displayValueOnlySeparator = (String)values[10];
        this.onchange = (String)values[11];
        this.cssStyle = (String)values[12];
        this.cssStyleClass = (String)values[13];
        this.size = (String)values[14];
        this.directoryValues = (VocabularyEntryList)values[15];
        this.ordering = (String)values[16];
        this.display = (String)values[17];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[18];
        values[0] = super.saveState(context);
        values[1] = this.getIndex();
        values[2] = this.displayIdAndLabel;
        values[3] = this.displayIdAndLabelSeparator;
        values[4] = this.displayObsoleteEntries;
        values[5] = this.ajaxUpdated;
        values[6] = this.directoryName;
        values[7] = this.localize;
        values[10] = this.displayValueOnlySeparator;
        values[11] = this.onchange;
        values[12] = this.cssStyle;
        values[13] = this.cssStyleClass;
        values[14] = this.size;
        values[15] = this.directoryValues;
        values[16] = this.ordering;
        values[17] = this.display;
        return values;
    }

    public String getDirectoryName() {
        ValueBinding vb = this.getValueBinding("directoryName");
        if (vb != null) {
            return (String)vb.getValue(FacesContext.getCurrentInstance());
        }
        return this.directoryName;
    }

    public void setDirectoryName(String newDirectory) {
        this.directoryName = newDirectory;
    }

    public VocabularyEntryList getDirectoryValues() {
        ValueBinding vb = this.getValueBinding("directoryValues");
        if (vb != null) {
            return (VocabularyEntryList)vb.getValue(FacesContext.getCurrentInstance());
        }
        return null;
    }

    public void setDirectoryValues(VocabularyEntryList directoryValues) {
        this.directoryValues = directoryValues;
    }

    public Map<String, DirectorySelectItem> getOptions() {
        this.index = this.getIndex();
        if (this.index == 0 || this.getChain().getSelection(0).getColumnValue(this.index - 1) != null) {
            return this.rebuildOptions();
        }
        return new HashMap<String, DirectorySelectItem>();
    }

    public Boolean getDisplayIdAndLabel() {
        return this.displayIdAndLabel;
    }

    public void setDisplayIdAndLabel(Boolean displayIdAndLabel) {
        this.displayIdAndLabel = displayIdAndLabel;
    }

    public Boolean getDisplayObsoleteEntries() {
        return this.displayObsoleteEntries;
    }

    public void setDisplayObsoleteEntries(Boolean showObsolete) {
        this.displayObsoleteEntries = showObsolete;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public ChainSelect getChain() {
        UIComponent component;
        for (component = this.getParent(); component != null && !(component instanceof ChainSelect); component = component.getParent()) {
        }
        return (ChainSelect)component;
    }

    public Object getProperty(String name) {
        ValueBinding vb = this.getValueBinding(name);
        if (vb != null) {
            return vb.getValue(FacesContext.getCurrentInstance());
        }
        return this.getAttributes().get(name);
    }

    public String getStringProperty(String name, String defaultValue) {
        String value = (String)this.getProperty(name);
        return value != null ? value : defaultValue;
    }

    public Boolean getBooleanProperty(String name, Boolean defaultValue) {
        Boolean value = (Boolean)this.getProperty(name);
        return value != null ? value : defaultValue;
    }

    public String getDisplayValueOnlySeparator() {
        return this.displayValueOnlySeparator;
    }

    public void setDisplayValueOnlySeparator(String displayValueOnlySeparator) {
        this.displayValueOnlySeparator = displayValueOnlySeparator;
    }

    public boolean isAjaxUpdated() {
        return this.ajaxUpdated;
    }

    public void setAjaxUpdated(boolean ajaxUpdated) {
        this.ajaxUpdated = ajaxUpdated;
    }

    public Integer getIndex() {
        ValueBinding vb = this.getValueBinding("index");
        if (vb != null) {
            return (Integer)vb.getValue(FacesContext.getCurrentInstance());
        }
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public String getCssStyleClass() {
        return this.cssStyleClass;
    }

    public void setCssStyleClass(String cssStyleClass) {
        this.cssStyleClass = cssStyleClass;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Boolean getLocalize() {
        return this.localize;
    }

    public void setLocalize(Boolean localize) {
        this.localize = localize;
    }

    public LinkedHashMap<String, DirectorySelectItem> rebuildOptions() {
        this.index = this.getIndex();
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        Boolean displayObsolete = this.getBooleanProperty("displayObsoleteEntries", Boolean.FALSE);
        if (!displayObsolete.booleanValue()) {
            filter.put("obsolete", Integer.valueOf(0));
        }
        String directoryName = this.getDirectoryName();
        String defaultRootKey = this.getChain().getDefaultRootKey();
        if (this.index == 0) {
            if (directoryName != null) {
                if (DirectoryHelper.instance().hasParentColumn(directoryName)) {
                    filter.put("parent", (Serializable)((Object)defaultRootKey));
                }
            } else {
                filter.put("parent", (Serializable)((Object)defaultRootKey));
            }
        } else {
            boolean qualifiedParentKeys = this.getChain().isQualifiedParentKeys();
            String keySeparator = this.getChain().getKeySeparator();
            Selection sel = this.getChain().getSelections()[0];
            String parentValue = sel.getParentKey(this.index, qualifiedParentKeys, keySeparator);
            if (parentValue == null) {
                parentValue = defaultRootKey;
            }
            filter.put("parent", (Serializable)((Object)parentValue));
        }
        VocabularyEntryList directoryValues = this.getDirectoryValues();
        List<DirectorySelectItem> list = directoryName != null ? DirectoryHelper.instance().getSelectItems(directoryName, filter) : DirectoryHelper.getSelectItems(directoryValues, filter);
        for (DirectorySelectItem item : list) {
            String label;
            String id = (String)item.getValue();
            String translatedLabel = label = item.getLabel();
            Boolean localize = this.getBooleanProperty("localize", Boolean.FALSE);
            if (localize.booleanValue()) {
                translatedLabel = ChainSelectListboxComponent.translate(label);
            }
            item.setLocalizedLabel(translatedLabel);
            String displayedLabel = translatedLabel;
            Boolean displayIdAndLabel = this.getBooleanProperty("displayIdAndLabel", Boolean.FALSE);
            if (displayIdAndLabel.booleanValue()) {
                displayedLabel = id + this.displayIdAndLabelSeparator + label;
            }
            item.setDisplayedLabel(displayedLabel);
        }
        String ordering = this.getStringProperty("ordering", "");
        if (ordering != null && !"".equals(ordering)) {
            Collections.sort(list, new DirectorySelectItemComparator(ordering));
        }
        LinkedHashMap<String, DirectorySelectItem> options = new LinkedHashMap<String, DirectorySelectItem>();
        options.clear();
        for (DirectorySelectItem item : list) {
            options.put((String)item.getValue(), item);
        }
        return options;
    }

    private static String translate(String label) {
        FacesContext context = FacesContext.getCurrentInstance();
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }

    public void decode(FacesContext context) {
        Selection[] selections;
        boolean stop;
        String[] lastValues;
        ChainSelect chain = this.getChain();
        if (chain.getDisplayValueOnly().booleanValue()) {
            return;
        }
        this.index = this.getIndex();
        chain.setCompAtIndex(this.index, this);
        List<String> keyList = chain.getSelectionKeyList();
        int size = chain.getSize();
        String formerValue = chain.getSelection(0).getColumnValue(this.index);
        if (this.index == 0) {
            chain.setLastSelectedComponentIndex(Integer.MAX_VALUE);
            keyList.clear();
        }
        if (chain.getLastSelectedComponentIndex() < this.index) {
            for (int i = this.index; i < size; ++i) {
                chain.setOptions(i, null);
            }
            LinkedHashMap<String, DirectorySelectItem> options = this.rebuildOptions();
            chain.setOptions(this.index, options);
            return;
        }
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Map requestValueMap = context.getExternalContext().getRequestParameterValuesMap();
        String name = this.getClientId(context);
        String value = (String)requestMap.get(name);
        if (value == null || value.length() == 0) {
            if (chain.getLastSelectedComponentIndex() > this.index) {
                chain.setLastSelectedComponentIndex(this.index);
            }
            for (int i = this.index; i < chain.getSize(); ++i) {
                chain.setOptions(i, null);
            }
            LinkedHashMap<String, DirectorySelectItem> options = this.rebuildOptions();
            chain.setOptions(this.index, options);
        } else {
            keyList.add(value);
        }
        if (!StringUtils.equals((CharSequence)value, (CharSequence)formerValue)) {
            chain.setLastSelectedComponentIndex(this.index);
            for (int i = this.index; i < chain.getSize(); ++i) {
                chain.setOptions(i, null);
            }
        }
        boolean lastValueIsOk = (lastValues = (String[])requestValueMap.get(name)) != null && lastValues.length != 0 && !StringUtils.isEmpty((CharSequence)lastValues[0]);
        boolean bl = stop = chain.getLastSelectedComponentIndex() < this.index;
        if (this.index == size - 1 && lastValueIsOk && !stop) {
            String[] keyListArray = new String[size];
            selections = new Selection[lastValues.length];
            keyListArray = keyList.toArray(keyListArray);
            for (int i = 0; i < lastValues.length; ++i) {
                keyListArray[size - 1] = lastValues[i];
                selections[i] = chain.createSelection(keyListArray);
            }
        } else {
            selections = new Selection[1];
            String[] columns = keyList.toArray(new String[0]);
            selections[0] = chain.createSelection(columns);
        }
        if (chain.getLastSelectedComponentIndex() == this.index) {
            chain.setSelections(selections);
        }
        LinkedHashMap<String, DirectorySelectItem> options = this.rebuildOptions();
        chain.setOptions(this.index, options);
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public String getDisplay() {
        if (this.display != null) {
            return this.display;
        }
        if (Boolean.TRUE.equals(this.displayIdAndLabel)) {
            return "idAndLabel";
        }
        return "label";
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "valueChange";
    }
}

