/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.restAPI.SeamRestletFilter;
import org.nuxeo.ecm.platform.ui.web.restAPI.ThreadSafeRestletFilter;
import org.nuxeo.ecm.platform.ui.web.restAPI.service.PluggableRestletService;
import org.nuxeo.ecm.platform.ui.web.restAPI.service.RestletPluginDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.restlet.Restlet;
import org.restlet.ext.servlet.ServletAdapter;
import org.restlet.routing.Router;

public class RestletServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(RestletServlet.class);
    private static final long serialVersionUID = 1764653653643L;
    protected ServletAdapter adapter;

    public synchronized void init() throws ServletException {
        super.init();
        this.adapter = new ServletAdapter(this.getServletContext());
        Router restletRouter = new Router();
        PluggableRestletService service = (PluggableRestletService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.restAPI.service.PluggableRestletService"));
        if (service == null) {
            log.error((Object)"Unable to get Service org.nuxeo.ecm.platform.ui.web.restAPI.service.PluggableRestletService");
            throw new ServletException("Can't initialize Nuxeo Pluggable Restlet Service");
        }
        for (String restletName : service.getContributedRestletNames()) {
            Object restletToAdd;
            RestletPluginDescriptor plugin = service.getContributedRestletDescriptor(restletName);
            if (plugin.getUseSeam()) {
                SeamRestletFilter seamFilter = new SeamRestletFilter(plugin.getUseConversation());
                Restlet seamRestlet = service.getContributedRestletByName(restletName);
                seamFilter.setNext(seamRestlet);
                restletToAdd = seamFilter;
            } else if (plugin.isSingleton()) {
                restletToAdd = service.getContributedRestletByName(restletName);
            } else {
                ThreadSafeRestletFilter threadSafeRestletFilter = new ThreadSafeRestletFilter();
                Restlet restlet = service.getContributedRestletByName(restletName);
                threadSafeRestletFilter.setNext(restlet);
                restletToAdd = threadSafeRestletFilter;
            }
            for (String urlPattern : plugin.getUrlPatterns()) {
                restletRouter.attach(urlPattern, restletToAdd, 1);
            }
        }
        this.adapter.setNext((Restlet)restletRouter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean tx = false;
        if (!TransactionHelper.isTransactionActive()) {
            tx = TransactionHelper.startTransaction();
        }
        boolean ok = false;
        try {
            this.adapter.service(req, res);
            ok = true;
        }
        finally {
            if (!ok) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            if (tx && TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }
}

