/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.annotations.In;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

public abstract class AbstractUserGroupManagement {
    public static final String VIEW_HOME = "view_home";
    public static final String MAIN_TABS_CATEGORY = "MAIN_TABS";
    public static final String MAIN_TAB_HOME = "MAIN_TABS:home";
    public static final String NUXEO_ADMIN_CATEGORY = "NUXEO_ADMIN";
    public static final String USER_CENTER_CATEGORY = "USER_CENTER";
    public static final String USERS_GROUPS_MANAGER = "UsersGroupsManager";
    public static final String USERS_GROUPS_MANAGER_SUB_TAB = "UsersGroupsManager_sub_tab";
    public static final String USERS_GROUPS_HOME = "UsersGroupsHome";
    public static final String USERS_GROUPS_HOME_SUB_TAB = "UsersGroupsHome_sub_tab";
    public static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-0123456789.@";
    public static final String DEFAULT_LISTING_MODE = "search_only";
    public static final String DETAILS_VIEW_MODE = "view";
    public static final String USERS_GROUPS_MANAGEMENT_ACCESS_FILTER = "usersGroupsManagementAccess";
    @In(create=true)
    protected NuxeoPrincipal currentUser;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected ContentViewActions contentViewActions;
    @In(create=true)
    protected WebActions webActions;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    protected String searchString = "";
    protected String listingMode;
    protected String detailsMode;
    protected boolean showCreateForm;
    protected boolean showUserOrGroup;
    protected boolean shouldResetStateOnTabChange = true;

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getListingMode() {
        if (this.listingMode == null) {
            this.listingMode = this.computeListingMode();
            if (this.listingMode == null || this.listingMode.trim().isEmpty()) {
                this.listingMode = DEFAULT_LISTING_MODE;
            }
        }
        return this.listingMode;
    }

    protected abstract String computeListingMode();

    public void setListingMode(String listingMode) {
        this.listingMode = listingMode;
    }

    public String getDetailsMode() {
        if (this.detailsMode == null) {
            this.detailsMode = DETAILS_VIEW_MODE;
        }
        return this.detailsMode;
    }

    public void setDetailsMode(String mode) {
        this.detailsMode = mode;
    }

    public boolean isShowCreateForm() {
        return this.showCreateForm;
    }

    public void toggleShowCreateForm() {
        this.showCreateForm = !this.showCreateForm;
        this.detailsMode = null;
    }

    public boolean isShowUserOrGroup() {
        return this.showUserOrGroup;
    }

    public void toggleShowUserOrGroup() {
        this.showUserOrGroup = !this.showUserOrGroup;
        this.detailsMode = null;
    }

    protected List<String> getAllAdminGroups() {
        ArrayList<String> adminGroups = new ArrayList<String>();
        for (String adminGroup : this.userManager.getAdministratorsGroups()) {
            adminGroups.add(adminGroup);
            adminGroups.addAll(this.getAllSubGroups(adminGroup));
        }
        return adminGroups;
    }

    private List<String> getAllSubGroups(String groupName) {
        return this.getAllSubGroups(groupName, new ArrayList<String>());
    }

    private List<String> getAllSubGroups(String groupName, List<String> accumulator) {
        List subGroups = this.userManager.getGroupsInGroup(groupName);
        if (!subGroups.isEmpty()) {
            accumulator.addAll(subGroups);
            for (String name : subGroups) {
                this.getAllSubGroups(name, accumulator);
            }
        }
        return accumulator;
    }
}

