/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.css;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.seam.excel.css.PropertyBuilder;
import org.jboss.seam.excel.css.StyleMap;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class StyleStringParser {
    private static final char STYLE_SEPARATOR = ';';
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String STYLE_SHORTHAND_SEPARATOR = " ";
    private static final char ESCAPE_CHAR = '\'';
    private Log log = Logging.getLog(StyleStringParser.class);
    private String styleString;
    private Map<String, PropertyBuilder> propertyBuilderMap;
    private StyleMap styleMap = new StyleMap();
    private boolean escaping = false;

    public static StyleStringParser of(String styleString, Map<String, PropertyBuilder> propertyBuilderMap) {
        return new StyleStringParser(styleString, propertyBuilderMap);
    }

    protected StyleStringParser(String styleString, Map<String, PropertyBuilder> propertyBuilderMap) {
        this.styleString = styleString;
        this.propertyBuilderMap = propertyBuilderMap;
    }

    private void addStyle(StringBuilder styleBuilder) {
        String styleString = styleBuilder.toString();
        int keyValueBreakpointIndex = styleString.indexOf(KEY_VALUE_SEPARATOR);
        if (keyValueBreakpointIndex < 0) {
            this.log.warn((Object)"Key-value separator character #0 not found in style #1, dropping", new Object[]{KEY_VALUE_SEPARATOR + styleBuilder.toString()});
            return;
        }
        String styleName = styleString.substring(0, keyValueBreakpointIndex).toLowerCase().trim();
        if (!this.propertyBuilderMap.containsKey(styleName)) {
            this.log.warn((Object)"No property builder (unknown style) for property #0", new Object[]{styleName});
            return;
        }
        PropertyBuilder propertyBuilder = this.propertyBuilderMap.get(styleName);
        String styleValue = styleString.substring(keyValueBreakpointIndex + 1);
        this.log.trace((Object)"Parsed style #0 to #1 => #2", new Object[]{styleString, styleName, styleValue});
        String[] styleValues = StyleStringParser.trimArray(styleValue.trim().split(STYLE_SHORTHAND_SEPARATOR));
        this.styleMap.putAll(propertyBuilder.parseProperty(styleName, styleValues));
    }

    public static String[] trimArray(String[] array) {
        ArrayList<String> validValues = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            if ("".equals(array[i]) || STYLE_SHORTHAND_SEPARATOR.equals(array[i])) continue;
            validValues.add(array[i].toLowerCase().trim());
        }
        return validValues.toArray(new String[validValues.size()]);
    }

    public StyleMap parse() {
        StringCharacterIterator iterator = new StringCharacterIterator(this.styleString);
        StringBuilder styleBuilder = new StringBuilder();
        char c = iterator.first();
        while (c != '\uffff') {
            if ('\'' == c) {
                this.escaping = !this.escaping;
            } else if (';' == c && !this.escaping) {
                this.addStyle(styleBuilder);
                styleBuilder = new StringBuilder();
            } else {
                styleBuilder.append(c);
            }
            c = iterator.next();
        }
        if (styleBuilder.length() > 0) {
            this.addStyle(styleBuilder);
        }
        if (this.escaping) {
            this.log.warn((Object)"Unbalanced escape characters #0 in style #1", new Object[]{Character.valueOf('\''), styleBuilder.toString()});
        }
        return this.styleMap;
    }
}

