/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.threed.importer;

import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.threed.ThreeDConstants;
import org.nuxeo.runtime.api.Framework;

public class ThreeDImporter
extends AbstractFileImporter {
    public static final String MIMETYPE_ZIP = "application/zip";

    public DocumentModel createOrUpdate(FileImporterContext context) throws IOException {
        CoreSession session = context.getSession();
        Blob blob = context.getBlob();
        boolean isThreeD = ThreeDConstants.SUPPORTED_EXTENSIONS.contains(FileUtils.getFileExtension((String)blob.getFilename()));
        boolean isZipThreeD = MIMETYPE_ZIP.equals(blob.getMimeType());
        String title = null;
        if (isZipThreeD) {
            title = this.getModelFilename(blob);
            boolean bl = isZipThreeD = title != null;
        }
        if (!isThreeD && !isZipThreeD) {
            return null;
        }
        String path = context.getParentPath();
        DocumentModel container = session.getDocument((DocumentRef)new PathRef(path));
        String docType = this.getDocType(container);
        if (docType == null) {
            docType = this.getDefaultDocType();
        }
        if (isThreeD) {
            title = FileManagerUtils.fetchTitle((String)blob.getFilename());
        }
        DocumentModel doc = session.createDocumentModel(docType);
        doc.setPropertyValue("dc:title", (Serializable)((Object)title));
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        doc.setPathInfo(path, pss.generatePathSegment(doc));
        this.updateDocument(doc, blob);
        doc = session.createDocument(doc);
        session.save();
        return doc;
    }

    protected String getModelFilename(Blob zipContent) throws IOException {
        String threeDFilename = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(zipContent.getStream());){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                boolean isSupported = ThreeDConstants.SUPPORTED_EXTENSIONS.contains(FileUtils.getFileExtension((String)zipEntry.getName()));
                if (zipEntry.isDirectory() || !isSupported || zipEntry.getName().startsWith(".")) continue;
                threeDFilename = FileManagerUtils.fetchTitle((String)zipEntry.getName());
                break;
            }
        }
        return threeDFilename;
    }

    public String getDefaultDocType() {
        return "ThreeD";
    }

    public boolean isOverwriteByTitle() {
        return true;
    }
}

