/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.component.SelectItemFactory;

public abstract class SelectItemsFactory
extends SelectItemFactory {
    private static final Log log = LogFactory.getLog(SelectItemsFactory.class);

    @Override
    protected abstract String getVar();

    @Override
    protected abstract SelectItem createSelectItem();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SelectItem> createSelectItems(Object value) {
        Object varValue = this.saveRequestMapVarValue();
        try {
            ArrayList<SelectItem> items = new ArrayList<SelectItem>();
            if (value instanceof ListDataModel) {
                ListDataModel ldm = (ListDataModel)value;
                value = ldm.getWrappedData();
            }
            if (value instanceof Object[]) {
                Object[] array;
                for (Object currentItem : array = (Object[])value) {
                    SelectItem[] res = this.createSelectItemsFrom(currentItem);
                    if (res == null) continue;
                    items.addAll(Arrays.asList(res));
                }
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object currentItem : collection) {
                    SelectItem[] res = this.createSelectItemsFrom(currentItem);
                    if (res == null) continue;
                    items.addAll(Arrays.asList(res));
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                for (Map.Entry obj : map.entrySet()) {
                    Map.Entry currentItem = obj;
                    SelectItem[] res = this.createSelectItemsFrom(currentItem);
                    if (res == null) continue;
                    items.addAll(Arrays.asList(res));
                }
            } else if (value != null) {
                log.warn((Object)("Could not map values to select items, value is not supported: " + value));
            }
            ArrayList<SelectItem> arrayList = items;
            return arrayList;
        }
        finally {
            this.restoreRequestMapVarValue(varValue);
        }
    }

    protected SelectItem[] createSelectItemsFrom(Object item) {
        SelectItem selectItem;
        block5: {
            if (item instanceof SelectItemGroup) {
                return ((SelectItemGroup)item).getSelectItems();
            }
            selectItem = null;
            try {
                this.putIteratorToRequestParam(item);
                selectItem = this.createSelectItem();
                this.removeIteratorFromRequestParam();
            }
            catch (PropertyNotFoundException e) {
                if (item instanceof SelectItem) break block5;
                throw e;
            }
        }
        if (selectItem != null) {
            return new SelectItem[]{selectItem};
        }
        if (item instanceof SelectItem) {
            return new SelectItem[]{(SelectItem)item};
        }
        return null;
    }

    @Override
    public SelectItem createSelectItem(Object value) {
        throw new IllegalArgumentException("Use createSelectItems instead");
    }
}

