/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.Serializable;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;

public class CreateDocumentRestlet
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    private static final long serialVersionUID = -7223939557577366747L;

    public void handle(Request req, Response res) {
        this.logDeprecation();
        String repo = (String)req.getAttributes().get("repo");
        if (repo == null || repo.equals("*")) {
            CreateDocumentRestlet.handleError(res, "you must specify a repository");
            return;
        }
        try (CloseableCoreSession documentManager = CoreInstance.openCoreSession((String)repo);){
            String parentDocRef = (String)req.getAttributes().get("parentdocid");
            if (parentDocRef == null) {
                CreateDocumentRestlet.handleError(res, "you must specify a valid document IdRef for the parent document");
                return;
            }
            DocumentModel parentDm = documentManager.getDocument((DocumentRef)new IdRef(parentDocRef));
            PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            String docTypeName = CreateDocumentRestlet.getQueryParamValue(req, "docType", "File");
            String titleField = "dublincore:title";
            String title = CreateDocumentRestlet.getQueryParamValue(req, titleField, "New " + docTypeName);
            DocumentModel newDm = documentManager.createDocumentModel(docTypeName);
            Form queryParameters = req.getResourceRef().getQueryAsForm();
            for (String paramName : queryParameters.getNames()) {
                if (!"docType".equals(paramName)) {
                    newDm.setPropertyValue(paramName, (Serializable)((Object)CreateDocumentRestlet.getQueryParamValue(req, paramName, null)));
                }
                newDm.setPropertyValue(titleField, (Serializable)((Object)title));
            }
            newDm.setPathInfo(parentDm.getPathAsString(), pss.generatePathSegment(newDm));
            newDm = documentManager.createDocument(newDm);
            documentManager.save();
            DOMDocumentFactory domFactory = new DOMDocumentFactory();
            DOMDocument resultDocument = (DOMDocument)domFactory.createDocument();
            Element docElement = resultDocument.addElement(documentTag);
            docElement.addElement(docRepositoryTag).setText(newDm.getRepositoryName());
            docElement.addElement(docRefTag).setText(newDm.getRef().toString());
            docElement.addElement(docTitleTag).setText(newDm.getTitle());
            docElement.addElement(docPathTag).setText(newDm.getPathAsString());
            StringRepresentation rep = new StringRepresentation((CharSequence)resultDocument.asXML(), MediaType.APPLICATION_XML);
            rep.setCharacterSet(CharacterSet.UTF_8);
            res.setEntity((Representation)rep);
        }
        catch (NuxeoException e) {
            CreateDocumentRestlet.handleError(res, (Exception)((Object)e));
        }
    }
}

