/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.commons.fileupload.FileUploadException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.util.FileUploadHelper;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;

public class PluginUploadRestlet
extends BaseNuxeoRestlet
implements Serializable {
    private static final long serialVersionUID = 1L;

    public void handle(Request req, Response res) {
        this.logDeprecation();
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String returnCode = "TRANSF_ERROR";
        String relativePath = "";
        List segments = req.getResourceRef().getSegments();
        int pos = segments.indexOf("restAPI") + 4;
        List pathElements = segments.subList(pos, segments.size() - 1);
        String fileName = (String)segments.get(segments.size() - 1);
        for (String pathElement : pathElements) {
            if (pathElement == null || pathElement.trim().equals("")) continue;
            try {
                relativePath = relativePath + '/' + URLDecoder.decode(pathElement, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)repo);){
            List<Blob> blobs;
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docid));
            DocumentModel folder = session.getDocument((DocumentRef)new PathRef(doc.getPathAsString() + relativePath));
            try {
                blobs = FileUploadHelper.parseRequest(req);
            }
            catch (IOException | FileUploadException e) {
                PluginUploadRestlet.handleError(res, (Exception)e);
                if (session != null) {
                    if (var12_13 != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable) {
                            var12_13.addSuppressed(throwable);
                        }
                    } else {
                        session.close();
                    }
                }
                return;
            }
            Blob blob = blobs.get(0);
            try {
                blob.setFilename(fileName);
                returnCode = this.addBinaryFileFromPlugin(blob, folder);
            }
            catch (NuxeoException e) {
                PluginUploadRestlet.handleError(res, (Exception)((Object)e));
                if (session != null) {
                    if (var12_13 != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable) {
                            var12_13.addSuppressed(throwable);
                        }
                    } else {
                        session.close();
                    }
                }
                return;
            }
        }
        catch (IOException | NuxeoException e) {
            PluginUploadRestlet.handleError(res, (Exception)e);
            return;
        }
        StringRepresentation rep = new StringRepresentation((CharSequence)returnCode, MediaType.TEXT_PLAIN);
        rep.setCharacterSet(CharacterSet.UTF_8);
        res.setEntity((Representation)rep);
    }

    protected String addBinaryFileFromPlugin(Blob blob, DocumentModel folder) throws IOException {
        FileManager fileManager = (FileManager)Framework.getService(FileManager.class);
        FileImporterContext context = FileImporterContext.builder((CoreSession)folder.getCoreSession(), (Blob)blob, (String)folder.getPathAsString()).overwrite(true).build();
        DocumentModel doc = fileManager.createOrUpdateDocument(context);
        return doc.getName();
    }
}

