/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;

public class UpdateDocumentRestlet
extends BaseStatelessNuxeoRestlet
implements LiveEditConstants {
    private static final Log log = LogFactory.getLog(UpdateDocumentRestlet.class);

    @Override
    protected void doHandleStatelessRequest(Request req, Response res) {
        this.logDeprecation();
        String repoId = (String)req.getAttributes().get("repo");
        String docId = (String)req.getAttributes().get("docid");
        DOMDocumentFactory domFactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domFactory.createDocument();
        boolean initOk = this.initRepositoryAndTargetDocument(res, repoId, docId);
        if (!initOk) {
            return;
        }
        try {
            Form queryParameters = req.getResourceRef().getQueryAsForm();
            for (String paramName : queryParameters.getNames()) {
                if ("docType".equals(paramName)) continue;
                this.targetDocument.setPropertyValue(paramName, (Serializable)((Object)UpdateDocumentRestlet.getQueryParamValue(req, paramName, null)));
            }
            this.session.saveDocument(this.targetDocument);
            this.session.save();
            Element docElement = result.addElement(documentTag);
            docElement.addElement(docRefTag).setText("Document " + docId + " has been updated");
            res.setEntity(result.asXML(), MediaType.APPLICATION_XML);
            res.getEntity().setCharacterSet(CharacterSet.UTF_8);
        }
        catch (NuxeoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            UpdateDocumentRestlet.handleError(res, (Exception)((Object)e));
        }
    }
}

