/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;

public class UploadFileRestlet
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    public static final String LIVED_AUTOVERSIONING_PROP = "org.nuxeo.ecm.platform.liveedit.autoversioning";
    public static final String POLICY_MINOR_INCR = "minor";
    private static final long serialVersionUID = -6167207806181917456L;

    public void handle(Request req, Response res) {
        this.logDeprecation();
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String filename = (String)req.getAttributes().get("filename");
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            UploadFileRestlet.handleError(res, e);
            return;
        }
        if (repo == null || repo.equals("*")) {
            UploadFileRestlet.handleError(res, "you must specify a repository");
            return;
        }
        DocumentModel dm = null;
        try (CloseableCoreSession documentManager = CoreInstance.openCoreSession((String)repo);){
            String blobPropertyName;
            if (docid != null) {
                dm = documentManager.getDocument((DocumentRef)new IdRef(docid));
            }
            if ((blobPropertyName = UploadFileRestlet.getQueryParamValue(req, "blobPropertyName", null)) == null) {
                String schemaName = UploadFileRestlet.getQueryParamValue(req, "schema", "file");
                String blobFieldName = UploadFileRestlet.getQueryParamValue(req, "blobField", "content");
                blobPropertyName = schemaName + ":" + blobFieldName;
            }
            try (InputStream is = req.getEntity().getStream();){
                this.saveFileToDocument(filename, dm, blobPropertyName, is);
            }
        }
        catch (IOException | NuxeoException e) {
            UploadFileRestlet.handleError(res, (Exception)e);
        }
    }

    @Deprecated
    protected void saveFileToDocument(String filename, DocumentModel dm, String blobPropertyName, String filenamePropertyName, InputStream is) throws IOException, PropertyException {
        this.saveFileToDocument(filename, dm, blobPropertyName, is);
    }

    protected void saveFileToDocument(String filename, DocumentModel dm, String blobPropertyName, InputStream is) throws IOException, PropertyException {
        Blob blob = Blobs.createBlob((InputStream)is);
        blob.setFilename(filename);
        dm.setPropertyValue(blobPropertyName, (Serializable)blob);
        dm.getCoreSession().saveDocument(dm);
        String versioningPolicy = Framework.getProperty((String)LIVED_AUTOVERSIONING_PROP);
        if (this.doAutoMinorIncrement(versioningPolicy, dm) && dm.isCheckedOut()) {
            dm.checkIn(VersioningOption.MINOR, "Live edit (UploadFileRestlet) autoversioning");
        }
        dm.getCoreSession().save();
    }

    protected boolean doAutoMinorIncrement(String policy, DocumentModel doc) {
        return POLICY_MINOR_INCR.equals(policy);
    }
}

