/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.event;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.hibernate.validator.ClassValidator;

public class JPAValidateListener {
    private static final Map<Class, WeakReference<ClassValidator>> validators = new WeakHashMap<Class, WeakReference<ClassValidator>>();
    private static final ClassValidator<JPAValidateListener> NO_VALIDATOR = new ClassValidator<JPAValidateListener>(JPAValidateListener.class);
    private final Set<ClassValidator> currentValidators = new HashSet<ClassValidator>();

    @PrePersist
    @PreUpdate
    public void onChange(Object object) {
        ClassValidator<Object> validator;
        if (object == null) {
            return;
        }
        Class<?> entity = object.getClass();
        WeakReference<ClassValidator> weakValidator = validators.get(entity);
        ClassValidator classValidator = validator = weakValidator != null ? (ClassValidator)weakValidator.get() : null;
        if (validator == null) {
            validator = new ClassValidator(entity);
            if (!validator.hasValidationRules()) {
                validator = NO_VALIDATOR;
            }
            validators.put(entity, new WeakReference(validator));
            this.currentValidators.add(validator);
        }
        if (validator != NO_VALIDATOR) {
            validator.assertValid(object);
        }
    }
}

