/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.faces.facelets.el.VariableMapperWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.FieldDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTagHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.binding.BlockingVariableMapper;
import org.nuxeo.ecm.platform.ui.web.tag.handler.SetTagHandler;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class WidgetTypeTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(WidgetTypeTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute name;
    protected final TagAttribute category;
    protected final TagAttribute mode;
    protected final TagAttribute value;
    protected final TagAttribute field;
    protected final TagAttribute fields;
    protected final TagAttribute label;
    protected final TagAttribute helpLabel;
    protected final TagAttribute translated;
    protected final TagAttribute properties;
    protected final TagAttribute widgetName;
    protected final TagAttribute ignoreTemplateProperty;
    protected final TagAttribute subWidgets;
    protected final TagAttribute resolveOnly;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "name", "category", "mode", "value", "type", "field", "fields", "widgetName", "label", "helpLabel", "translated", "properties", "ignoreTemplateProperty", "subWidgets", "resolveOnly"};

    public WidgetTypeTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.name = this.getRequiredAttribute("name");
        this.category = this.getAttribute("category");
        this.mode = this.getRequiredAttribute("mode");
        this.value = this.getAttribute("value");
        this.field = this.getAttribute("field");
        this.fields = this.getAttribute("fields");
        this.widgetName = this.getAttribute("widgetName");
        this.label = this.getAttribute("label");
        this.helpLabel = this.getAttribute("helpLabel");
        this.translated = this.getAttribute("translated");
        this.properties = this.getAttribute("properties");
        this.ignoreTemplateProperty = this.getAttribute("ignoreTemplateProperty");
        this.subWidgets = this.getAttribute("subWidgets");
        this.resolveOnly = this.getAttribute("resolveOnly");
        this.vars = this.tag.getAttributes().getAll();
    }

    public final void apply(FaceletContext ctx, UIComponent parent) throws IOException, ELException {
        Map propertiesValue;
        WebLayoutManager layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        ArrayList<Object> fieldsValue = new ArrayList<Object>();
        if (this.field != null) {
            Object fieldValue = this.field.getObject(ctx, Object.class);
            if (fieldValue instanceof FieldDefinition) {
                fieldsValue.add((FieldDefinition)fieldValue);
            } else if (fieldValue instanceof String) {
                fieldsValue.add(new FieldDefinitionImpl(null, (String)fieldValue));
            } else {
                fieldsValue.add(new FieldDefinitionImpl(null, this.field.getValue()));
            }
        }
        if (this.fields != null) {
            List resolvedfields = (List)this.fields.getObject(ctx, List.class);
            for (Object item : resolvedfields) {
                if (item instanceof FieldDefinition) {
                    fieldsValue.add((FieldDefinition)item);
                    continue;
                }
                if (item instanceof String) {
                    fieldsValue.add(new FieldDefinitionImpl(null, (String)item));
                    continue;
                }
                log.error((Object)("Invalid field item => discard: " + item));
            }
        }
        List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
        HashMap<String, String> widgetProps = new HashMap<String, String>();
        if (this.properties != null && (propertiesValue = (Map)this.properties.getObject(ctx, Map.class)) != null) {
            widgetProps.putAll(propertiesValue);
        }
        String widgetPropertyMarker = RenderVariables.widgetVariables.widgetProperty.name() + "_";
        boolean includeValueInProps = fieldsValue.isEmpty();
        for (TagAttribute var : this.vars) {
            String localName = var.getLocalName();
            if (reservedVars.contains(localName) && (!"value".equals(localName) || !includeValueInProps)) continue;
            String varName = localName;
            if (localName != null && localName.startsWith(widgetPropertyMarker)) {
                varName = localName.substring(widgetPropertyMarker.length());
            }
            widgetProps.put(varName, var.getValue());
        }
        boolean ignoreTemplatePropValue = false;
        if (this.ignoreTemplateProperty != null) {
            ignoreTemplatePropValue = this.ignoreTemplateProperty.getBoolean(ctx);
        }
        if (ignoreTemplatePropValue) {
            widgetProps.remove("template");
        }
        String typeValue = this.name.getValue(ctx);
        String categoryValue = null;
        if (this.category != null) {
            categoryValue = this.category.getValue(ctx);
        }
        String modeValue = this.mode.getValue(ctx);
        String valueName = null;
        if (this.value != null && ComponentTagUtils.isStrictValueReference((String)(valueName = this.value.getValue()))) {
            valueName = ComponentTagUtils.getBareValueName((String)valueName);
        }
        String widgetNameValue = null;
        if (this.widgetName != null) {
            widgetNameValue = this.widgetName.getValue(ctx);
        }
        String labelValue = null;
        if (this.label != null) {
            labelValue = this.label.getValue(ctx);
        }
        String helpLabelValue = null;
        if (this.helpLabel != null) {
            helpLabelValue = this.helpLabel.getValue(ctx);
        }
        Boolean translatedValue = Boolean.FALSE;
        if (this.translated != null) {
            translatedValue = this.translated.getBoolean(ctx);
        }
        Widget[] subWidgetsValue = null;
        if (this.subWidgets != null) {
            subWidgetsValue = (Widget[])this.subWidgets.getObject(ctx, Widget[].class);
        }
        if (widgetNameValue != null && widgetNameValue.startsWith("nxw_")) {
            widgetNameValue = widgetNameValue.substring("nxw_".length());
        }
        if (StringUtils.isBlank((CharSequence)widgetNameValue)) {
            widgetNameValue = typeValue;
        }
        WidgetDefinitionImpl wDef = new WidgetDefinitionImpl(widgetNameValue, typeValue, labelValue, helpLabelValue, translatedValue.booleanValue(), null, fieldsValue, widgetProps, null);
        wDef.setTypeCategory(categoryValue);
        wDef.setDynamic(true);
        Widget widget = layoutService.createWidget(ctx, (WidgetDefinition)wDef, modeValue, valueName, subWidgetsValue);
        if (FaceletHandlerHelper.isAliasOptimEnabled()) {
            this.applyOptimized(ctx, parent, widget);
        } else {
            this.applyCompat(ctx, parent, widget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyOptimized(FaceletContext ctx, UIComponent parent, Widget widget) throws IOException, ELException {
        VariableMapper orig = ctx.getVariableMapper();
        try {
            BlockingVariableMapper vm = new BlockingVariableMapper(orig);
            ctx.setVariableMapper((VariableMapper)vm);
            FaceletHandlerHelper helper = new FaceletHandlerHelper(this.config);
            WidgetTagHandler.generateWidgetId(ctx, helper, widget, false);
            WidgetTagHandler.exposeWidgetVariables(ctx, vm, widget, null, true);
            boolean resolveOnlyBool = false;
            if (this.resolveOnly != null) {
                resolveOnlyBool = this.resolveOnly.getBoolean(ctx);
            }
            if (resolveOnlyBool) {
                this.nextHandler.apply(ctx, parent);
            } else {
                WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widget, this.value, true, this.nextHandler);
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCompat(FaceletContext ctx, UIComponent parent, Widget widget) throws IOException, ELException {
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapperWrapper vm = new VariableMapperWrapper(orig);
        ctx.setVariableMapper((VariableMapper)vm);
        ValueExpression widgetVe = ctx.getExpressionFactory().createValueExpression((Object)widget, Widget.class);
        vm.setVariable(RenderVariables.widgetVariables.widget.name(), widgetVe);
        vm.setVariable(RenderVariables.widgetVariables.widget.name() + "_" + widget.getLevel(), widgetVe);
        try {
            FaceletHandlerHelper helper = new FaceletHandlerHelper(this.config);
            WidgetTagHandler.generateWidgetId(ctx, helper, widget, false);
            boolean resolveOnlyBool = false;
            if (this.resolveOnly != null) {
                resolveOnlyBool = this.resolveOnly.getBoolean(ctx);
            }
            if (resolveOnlyBool) {
                String setTagConfigId = widget.getTagConfigId();
                ComponentConfig aliasConfig = TagConfigFactory.createAliasTagConfig((TagConfig)this.config, (String)setTagConfigId, (String)RenderVariables.widgetVariables.widget.name(), (String)"#{widget}", (String)"true", (String)"true", (FaceletHandler)this.nextHandler);
                SetTagHandler handler = new SetTagHandler(aliasConfig);
                handler.apply(ctx, parent);
            } else {
                WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widget, this.value, true, this.nextHandler);
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }
}

